/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.vfs;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.AbstractPollTableEntry;
import org.apache.axis2.transport.base.ParamUtils;

public class PollTableEntry
extends AbstractPollTableEntry {
    public static final int DELETE = 0;
    public static final int MOVE = 1;
    private String fileURI;
    private String replyFileURI;
    private String fileNamePattern;
    private String contentType;
    private int actionAfterProcess = 0;
    private int actionAfterErrors = 0;
    private int actionAfterFailure = 0;
    private String moveAfterProcess;
    private String moveAfterErrors;
    private String moveAfterFailure;
    private DateFormat moveTimestampFormat;
    private boolean streaming;
    private int maxRetryCount;
    private long reconnectTimeout;
    private boolean fileLocking;

    public PollTableEntry(boolean fileLocking) {
        this.fileLocking = fileLocking;
    }

    public EndpointReference[] getEndpointReferences(String ip) {
        return new EndpointReference[]{new EndpointReference("vfs:" + this.fileURI)};
    }

    public String getFileURI() {
        return this.fileURI;
    }

    public String getReplyFileURI() {
        return this.replyFileURI;
    }

    public String getFileNamePattern() {
        return this.fileNamePattern;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getActionAfterProcess() {
        return this.actionAfterProcess;
    }

    public int getActionAfterErrors() {
        return this.actionAfterErrors;
    }

    public int getActionAfterFailure() {
        return this.actionAfterFailure;
    }

    public String getMoveAfterProcess() {
        return this.moveAfterProcess;
    }

    private void setMoveAfterProcess(String moveAfterProcess) {
        this.moveAfterProcess = moveAfterProcess == null ? null : (moveAfterProcess.startsWith("vfs:") ? moveAfterProcess.substring("vfs:".length()) : moveAfterProcess);
    }

    public String getMoveAfterErrors() {
        return this.moveAfterErrors;
    }

    private void setMoveAfterErrors(String moveAfterErrors) {
        this.moveAfterErrors = moveAfterErrors == null ? null : (moveAfterErrors.startsWith("vfs:") ? moveAfterErrors.substring("vfs:".length()) : moveAfterErrors);
    }

    public String getMoveAfterFailure() {
        return this.moveAfterFailure;
    }

    private void setMoveAfterFailure(String moveAfterFailure) {
        this.moveAfterFailure = moveAfterFailure == null ? null : (moveAfterFailure.startsWith("vfs:") ? moveAfterFailure.substring("vfs:".length()) : moveAfterFailure);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public boolean isFileLockingEnabled() {
        return this.fileLocking;
    }

    public long getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    public DateFormat getMoveTimestampFormat() {
        return this.moveTimestampFormat;
    }

    public boolean loadConfiguration(ParameterInclude params) throws AxisFault {
        String strMaxRetryCount;
        String strStreaming;
        this.fileURI = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.vfs.FileURI");
        if (this.fileURI == null) {
            return false;
        }
        if (this.fileURI.startsWith("vfs:")) {
            this.fileURI = this.fileURI.substring("vfs:".length());
        }
        this.replyFileURI = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.vfs.ReplyFileURI");
        this.fileNamePattern = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.vfs.FileNamePattern");
        this.contentType = ParamUtils.getRequiredParam((ParameterInclude)params, (String)"transport.vfs.ContentType");
        String option = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.vfs.ActionAfterProcess");
        this.actionAfterProcess = "MOVE".equals(option) ? 1 : 0;
        option = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.vfs.ActionAfterErrors");
        this.actionAfterErrors = "MOVE".equals(option) ? 1 : 0;
        option = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.vfs.ActionAfterFailure");
        this.actionAfterFailure = "MOVE".equals(option) ? 1 : 0;
        String moveDirectoryAfterProcess = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.vfs.MoveAfterProcess");
        this.setMoveAfterProcess(moveDirectoryAfterProcess);
        String moveDirectoryAfterErrors = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.vfs.MoveAfterErrors");
        this.setMoveAfterErrors(moveDirectoryAfterErrors);
        String moveDirectoryAfterFailure = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.vfs.MoveAfterFailure");
        this.setMoveAfterFailure(moveDirectoryAfterFailure);
        String moveFileTimestampFormat = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.vfs.MoveTimestampFormat");
        if (moveFileTimestampFormat != null) {
            this.moveTimestampFormat = new SimpleDateFormat(moveFileTimestampFormat);
        }
        if ((strStreaming = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.vfs.Streaming")) != null) {
            this.streaming = Boolean.parseBoolean(strStreaming);
        }
        this.maxRetryCount = (strMaxRetryCount = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.vfs.MaxRetryCount")) != null ? Integer.parseInt(strMaxRetryCount) : 3;
        String strReconnectTimeout = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.vfs.ReconnectTimeout");
        this.reconnectTimeout = strReconnectTimeout != null ? (long)(Integer.parseInt(strReconnectTimeout) * 1000) : 30000L;
        String strFileLocking = ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.vfs.Locking");
        if ("enable".equals(strFileLocking)) {
            this.fileLocking = true;
        } else if ("disable".equals(strFileLocking)) {
            this.fileLocking = false;
        }
        return super.loadConfiguration(params);
    }
}

