/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.message.store.AbstractMessageStore;
import org.apache.synapse.message.store.StorableMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryMessageStore
extends AbstractMessageStore {
    private static final Log log = LogFactory.getLog(InMemoryMessageStore.class);
    private Map<String, StorableMessage> messageList = new HashMap<String, StorableMessage>();

    @Override
    public void store(StorableMessage storableMessage) {
        if (storableMessage != null) {
            this.mediateSequence(storableMessage.getMessageContext());
            this.messageList.put(storableMessage.getMessageContext().getMessageID(), storableMessage);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Message " + storableMessage.getMessageContext().getMessageID() + " has been stored"));
            }
        }
    }

    @Override
    public StorableMessage unstore(String messageID) {
        if (messageID != null) {
            return this.messageList.remove(messageID);
        }
        return null;
    }

    @Override
    public List<StorableMessage> unstoreAll() {
        ArrayList<StorableMessage> returnList = new ArrayList<StorableMessage>();
        for (String k : this.messageList.keySet()) {
            returnList.add(this.messageList.remove(k));
        }
        return returnList;
    }

    @Override
    public List<StorableMessage> getAllMessages() {
        ArrayList<StorableMessage> returnlist = new ArrayList<StorableMessage>();
        Iterator<String> it = this.messageList.keySet().iterator();
        while (it.hasNext()) {
            returnlist.add(this.messageList.get(it.next()));
        }
        return returnlist;
    }

    @Override
    public StorableMessage getMessage(String messageId) {
        if (messageId != null) {
            return this.messageList.get(messageId);
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.messageList.size();
    }
}

