/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.MediatorSerializerFinder;
import org.apache.synapse.deployers.AbstractSynapseArtifactDeployer;
import org.apache.synapse.mediators.base.SequenceMediator;

public class SequenceDeployer
extends AbstractSynapseArtifactDeployer {
    private static Log log = LogFactory.getLog(SequenceDeployer.class);

    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sequence Deployment from file : " + fileName + " : Started"));
        }
        try {
            Mediator m = MediatorFactoryFinder.getInstance().getMediator(artifactConfig, properties);
            if (m instanceof SequenceMediator) {
                SequenceMediator seq = (SequenceMediator)m;
                seq.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sequence named '" + seq.getName() + "' has been built from the file " + fileName));
                }
                seq.init(this.getSynapseEnvironment());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialized the sequence : " + seq.getName()));
                }
                this.getSynapseConfiguration().addSequence(seq.getName(), seq);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sequence Deployment from file : " + fileName + " : Completed"));
                }
                log.info((Object)("Sequence named '" + seq.getName() + "' has been deployed from file : " + fileName));
                return seq.getName();
            }
            this.handleSynapseArtifactDeploymentError("Sequence Deployment Failed. The artifact described in the file " + fileName + " is not a Sequence");
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Sequence Deployment from the file : " + fileName + " : Failed.", e);
        }
        return null;
    }

    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sequence Update from file : " + fileName + " : Started"));
        }
        try {
            Mediator m = MediatorFactoryFinder.getInstance().getMediator(artifactConfig, properties);
            if (m instanceof SequenceMediator) {
                SequenceMediator seq = (SequenceMediator)m;
                if (("main".equals(existingArtifactName) || "fault".equals(existingArtifactName)) && !existingArtifactName.equals(seq.getName())) {
                    this.handleSynapseArtifactDeploymentError(existingArtifactName + " sequence cannot be renamed");
                }
                seq.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sequence named '" + seq.getName() + "' has been built from the file " + fileName));
                }
                seq.init(this.getSynapseEnvironment());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialized the sequence : " + seq.getName()));
                }
                SequenceMediator existingSeq = this.getSynapseConfiguration().getDefinedSequences().get(existingArtifactName);
                this.getSynapseConfiguration().removeSequence(existingArtifactName);
                if (!existingArtifactName.equals(seq.getName())) {
                    log.info((Object)("Sequence named '" + existingArtifactName + "' has been Undeployed"));
                }
                this.getSynapseConfiguration().addSequence(seq.getName(), seq);
                existingSeq.destroy();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sequence " + (existingArtifactName.equals(seq.getName()) ? "update" : "deployment") + " from file : " + fileName + " : Completed"));
                }
                log.info((Object)("Sequence named '" + seq.getName() + "' has been " + (existingArtifactName.equals(seq.getName()) ? "update" : "deployed") + " from file : " + fileName));
                return seq.getName();
            }
            this.handleSynapseArtifactDeploymentError("Sequence Update Failed. The artifact described in the file " + fileName + " is not a Sequence");
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Sequence Update from the file : " + fileName + " : Failed.", e);
        }
        return null;
    }

    public void undeploySynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sequence Undeployment of the sequence named : " + artifactName + " : Started"));
        }
        try {
            SequenceMediator seq = this.getSynapseConfiguration().getDefinedSequences().get(artifactName);
            if (seq != null) {
                if ("main".equals(seq.getName()) || "fault".equals(seq.getName())) {
                    this.handleSynapseArtifactDeploymentError("Cannot Undeploy the " + seq.getName() + " sequence");
                }
                this.getSynapseConfiguration().removeSequence(artifactName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Destroying the sequence named : " + artifactName));
                }
                seq.destroy();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sequence Undeployment of the sequence named : " + artifactName + " : Completed"));
                }
                log.info((Object)("Sequence named '" + seq.getName() + "' has been undeployed"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Sequence " + artifactName + " has already been undeployed"));
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Sequence Undeployement of sequence named : " + artifactName + " : Failed", e);
        }
    }

    public void restoreSynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Restoring the Sequence with name : " + artifactName + " : Started"));
        }
        try {
            SequenceMediator seq = this.getSynapseConfiguration().getDefinedSequences().get(artifactName);
            OMElement seqElem = MediatorSerializerFinder.getInstance().getSerializer(seq).serializeMediator(null, seq);
            if (seq.getFileName() != null) {
                String fileName = this.getServerConfigurationInformation().getSynapseXMLLocation() + File.separator + "sequences" + File.separator + seq.getFileName();
                this.writeToFile(seqElem, fileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Restoring the Sequence with name : " + artifactName + " : Completed"));
                }
                log.info((Object)("Sequence named '" + artifactName + "' has been restored"));
            } else {
                this.handleSynapseArtifactDeploymentError("Couldn't restore the sequence named '" + artifactName + "', filename cannot be found");
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Restoring of the sequence named '" + artifactName + "' has failed", e);
        }
    }
}

