/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.concurrent.ExecutorService;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axiom.util.blob.OverflowBlob;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.statistics.StatisticsCollector;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.MediatorWorker;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.task.SynapseTaskManager;
import org.apache.synapse.util.concurrent.SynapseThreadPool;

public class Axis2SynapseEnvironment
implements SynapseEnvironment {
    private static final Log log = LogFactory.getLog(Axis2SynapseEnvironment.class);
    private SynapseConfiguration synapseConfig;
    private ConfigurationContext configContext;
    private ExecutorService executorService;
    private boolean initialized = false;
    private SynapseTaskManager taskManager;
    private StatisticsCollector statisticsCollector = new StatisticsCollector();
    private ServerContextInformation contextInformation;

    public Axis2SynapseEnvironment(SynapseConfiguration synCfg) {
        int coreThreads = 20;
        int maxThreads = 100;
        long keepAlive = 5L;
        int qLength = 10;
        try {
            qLength = Integer.parseInt(synCfg.getProperty("synapse.threads.qlen"));
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            coreThreads = Integer.parseInt(synCfg.getProperty("synapse.threads.core"));
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            maxThreads = Integer.parseInt(synCfg.getProperty("synapse.threads.max"));
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            keepAlive = Long.parseLong(synCfg.getProperty("synapse.threads.keepalive"));
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.executorService = new SynapseThreadPool(coreThreads, maxThreads, keepAlive, qLength, synCfg.getProperty("synapse.threads.group", "synapse-thread-group"), synCfg.getProperty("synapse.threads.idprefix", "SynapseWorker"));
        this.taskManager = new SynapseTaskManager();
    }

    public Axis2SynapseEnvironment(ConfigurationContext cfgCtx, SynapseConfiguration synapseConfig) {
        this(synapseConfig);
        this.configContext = cfgCtx;
        this.synapseConfig = synapseConfig;
    }

    public Axis2SynapseEnvironment(ConfigurationContext cfgCtx, SynapseConfiguration synapseConfig, ServerContextInformation contextInformation) {
        this(cfgCtx, synapseConfig);
        this.contextInformation = contextInformation;
    }

    public boolean injectMessage(MessageContext synCtx) {
        String proxyName;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Injecting MessageContext");
        }
        synCtx.setEnvironment(this);
        Mediator mandatorySeq = synCtx.getConfiguration().getMandatorySequence();
        if (mandatorySeq != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Start mediating the message in the pre-mediate state using the mandatory sequence");
            }
            if (!mandatorySeq.mediate(synCtx)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)((synCtx.isResponse() ? "Response" : "Request") + " message for the " + (synCtx.getProperty("proxy.name") != null ? "proxy service " + synCtx.getProperty("proxy.name") : "message mediation") + " dropped in the " + "pre-mediation state by the mandatory sequence : \n" + synCtx));
                }
                return false;
            }
        }
        if ((proxyName = (String)synCtx.getProperty("proxy.name")) == null || "".equals(proxyName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using Main Sequence for injected message");
            }
            return synCtx.getMainSequence().mediate(synCtx);
        }
        ProxyService proxyService = synCtx.getConfiguration().getProxyService(proxyName);
        if (proxyService != null) {
            if (proxyService.getTargetFaultSequence() != null) {
                Mediator faultSequence = synCtx.getSequence(proxyService.getTargetFaultSequence());
                if (faultSequence != null) {
                    synCtx.pushFaultHandler(new MediatorFaultHandler(faultSequence));
                } else {
                    log.warn((Object)("Cloud not find any fault-sequence named :" + proxyService.getTargetFaultSequence() + "; Setting the deafault" + " fault sequence for out path"));
                    synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getFaultSequence()));
                }
            } else if (proxyService.getTargetInLineFaultSequence() != null) {
                synCtx.pushFaultHandler(new MediatorFaultHandler(proxyService.getTargetInLineFaultSequence()));
            } else {
                synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getFaultSequence()));
            }
            Mediator outSequence = this.getProxyOutSequence(synCtx, proxyService);
            if (outSequence != null) {
                outSequence.mediate(synCtx);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(proxyService + " does not specifies an out-sequence - sending the response back"));
                }
                Axis2Sender.sendBack(synCtx);
            }
        }
        return true;
    }

    public void injectAsync(MessageContext synCtx, SequenceMediator seq) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Injecting MessageContext for asynchronous mediation using the : " + (seq.getName() == null ? "Anonymous" : seq.getName()) + " Sequence"));
        }
        synCtx.setEnvironment(this);
        this.executorService.execute(new MediatorWorker(seq, synCtx));
    }

    public void send(EndpointDefinition endpoint, MessageContext synCtx) {
        if (synCtx.isResponse()) {
            if (endpoint != null) {
                Axis2Sender.sendOn(endpoint, synCtx);
            } else {
                Axis2Sender.sendBack(synCtx);
            }
        } else {
            Dispatcher dispatcher = (Dispatcher)synCtx.getProperty("synape.sal.endpoints.dispatcher");
            if (dispatcher != null && !dispatcher.isServerInitiatedSession()) {
                dispatcher.updateSession(synCtx);
            }
            synCtx.setProperty("synapse.internal.request.sending", true);
            Axis2Sender.sendOn(endpoint, synCtx);
        }
    }

    public MessageContext createMessageContext() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating Message Context");
        }
        org.apache.axis2.context.MessageContext axis2MC = new org.apache.axis2.context.MessageContext();
        axis2MC.setConfigurationContext(this.configContext);
        ServiceContext svcCtx = new ServiceContext();
        OperationContext opCtx = new OperationContext((AxisOperation)new InOutAxisOperation(), svcCtx);
        axis2MC.setServiceContext(svcCtx);
        axis2MC.setOperationContext(opCtx);
        Axis2MessageContext mc = new Axis2MessageContext(axis2MC, this.synapseConfig, this);
        mc.setMessageID(UIDGenerator.generateURNString());
        try {
            mc.setEnvelope(OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope());
            mc.getEnvelope().addChild((OMNode)OMAbstractFactory.getSOAP12Factory().createSOAPBody());
        }
        catch (Exception e) {
            this.handleException("Unable to attach the SOAP envelope to the created new message context", e);
        }
        return mc;
    }

    public OverflowBlob createOverflowBlob() {
        String chkSize = this.synapseConfig.getProperty("synapse.temp_data.chunk.size");
        String chukNumber = this.synapseConfig.getProperty("synapse.temp_data.chunk.threshold");
        int numberOfChunks = 8;
        int chunkSize = 1024;
        if (chkSize != null) {
            chunkSize = Integer.parseInt(chkSize);
        }
        if (chukNumber != null) {
            numberOfChunks = Integer.parseInt(chukNumber);
        }
        String tempPrefix = this.synapseConfig.getProperty("synapse.tempfile.prefix", "tmp_");
        String tempSuffix = this.synapseConfig.getProperty("synapse.tempfile.sufix", ".dat");
        return new OverflowBlob(numberOfChunks, chunkSize, tempPrefix, tempSuffix);
    }

    public StatisticsCollector getStatisticsCollector() {
        return this.statisticsCollector;
    }

    @Deprecated
    public void setStatisticsCollector(StatisticsCollector collector) {
        this.statisticsCollector = collector;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean state) {
        this.initialized = state;
    }

    public SynapseConfiguration getSynapseConfiguration() {
        return this.synapseConfig;
    }

    public SynapseTaskManager getTaskManager() {
        return this.taskManager;
    }

    public ServerContextInformation getServerContextInformation() {
        return this.contextInformation;
    }

    public ConfigurationContext getAxis2ConfigurationContext() {
        return this.configContext;
    }

    private void handleException(String message, Throwable e) {
        log.error((Object)message, e);
        throw new SynapseException(message, e);
    }

    private Mediator getProxyOutSequence(MessageContext synCtx, ProxyService proxyService) {
        String sequenceName = proxyService.getTargetOutSequence();
        if (sequenceName != null && !"".equals(sequenceName)) {
            Mediator outSequence = synCtx.getSequence(sequenceName);
            if (outSequence != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using the sequence named " + sequenceName + " for the outgoing message mediation of the proxy service " + proxyService));
                }
                return outSequence;
            }
            log.error((Object)("Unable to find the out-sequence specified by the name " + sequenceName));
            throw new SynapseException("Unable to find the out-sequence specified by the name " + sequenceName);
        }
        SequenceMediator outSequence = proxyService.getTargetInLineOutSequence();
        if (outSequence != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using the anonymous out-sequence specified in the proxy service " + proxyService + " for outgoing message mediation"));
            }
            return outSequence;
        }
        return null;
    }
}

