/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractListMediatorFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.mediators.builtin.ValidateMediator;
import org.jaxen.JaxenException;
import org.xml.sax.SAXException;

public class ValidateMediatorFactory
extends AbstractListMediatorFactory {
    private static final QName VALIDATE_Q = new QName("http://ws.apache.org/ns/synapse", "validate");
    private static final QName ON_FAIL_Q = new QName("http://ws.apache.org/ns/synapse", "on-fail");
    private static final QName SCHEMA_Q = new QName("http://ws.apache.org/ns/synapse", "schema");

    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        ValidateMediator validateMediator = new ValidateMediator();
        ArrayList<String> schemaKeys = new ArrayList<String>();
        Iterator schemas = elem.getChildrenWithName(SCHEMA_Q);
        while (schemas.hasNext()) {
            Object o = schemas.next();
            if (o instanceof OMElement) {
                OMElement omElem = (OMElement)o;
                OMAttribute keyAtt = omElem.getAttribute(ATT_KEY);
                if (keyAtt != null) {
                    schemaKeys.add(keyAtt.getAttributeValue());
                    continue;
                }
                this.handleException("A 'schema' definition must contain a local property 'key'");
                continue;
            }
            this.handleException("Invalid 'schema' declaration for validate mediator");
        }
        if (schemaKeys.size() == 0) {
            this.handleException("No schema specified for the validate mediator");
        } else {
            validateMediator.setSchemaKeys(schemaKeys);
        }
        OMAttribute attSource = elem.getAttribute(ATT_SOURCE);
        if (attSource != null) {
            try {
                validateMediator.setSource(SynapseXPathFactory.getSynapseXPath(elem, ATT_SOURCE));
            }
            catch (JaxenException e) {
                this.handleException("Invalid XPath expression specified for attribute 'source'", (Exception)((Object)e));
            }
        }
        OMElement onFail = null;
        Iterator iterator = elem.getChildrenWithName(ON_FAIL_Q);
        if (iterator.hasNext()) {
            onFail = (OMElement)iterator.next();
        }
        if (onFail != null && onFail.getChildElements().hasNext()) {
            ValidateMediatorFactory.addChildren(onFail, validateMediator, properties);
        } else {
            this.handleException("A non-empty <on-fail> child element is required for the <validate> mediator");
        }
        this.processAuditStatus(validateMediator, elem);
        for (Map.Entry<String, String> entry : this.collectNameValuePairs(elem, FEATURE_Q).entrySet()) {
            boolean isFeatureEnabled;
            String value = entry.getValue();
            if ("true".equals(value)) {
                isFeatureEnabled = true;
            } else if ("false".equals(value)) {
                isFeatureEnabled = false;
            } else {
                this.handleException("The feature must have value true or false");
                break;
            }
            try {
                validateMediator.addFeature(entry.getKey(), isFeatureEnabled);
            }
            catch (SAXException e) {
                this.handleException("Error setting validation feature : " + entry.getKey() + " to : " + value, e);
            }
        }
        return validateMediator;
    }

    public QName getTagQName() {
        return VALIDATE_Q;
    }
}

