/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.commons.executors.config.PriorityExecutorFactory;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.ConfigurationFactory;
import org.apache.synapse.config.xml.EntryFactory;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.MessageStoreFactory;
import org.apache.synapse.config.xml.ProxyServiceFactory;
import org.apache.synapse.config.xml.RegistryFactory;
import org.apache.synapse.config.xml.StartupFinder;
import org.apache.synapse.config.xml.SynapseXMLConfigurationSerializer;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.eventing.EventSourceFactory;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.registry.Registry;

public class SynapseXMLConfigurationFactory
implements ConfigurationFactory {
    private static Log log = LogFactory.getLog(SynapseXMLConfigurationFactory.class);

    public SynapseConfiguration getConfiguration(OMElement definitions, Properties properties) {
        if (!definitions.getQName().equals(XMLConfigConstants.DEFINITIONS_ELT)) {
            throw new SynapseException("Wrong QName for this configuration factory " + definitions.getQName());
        }
        SynapseConfiguration config = SynapseConfigUtils.newConfiguration();
        config.setDefaultQName(definitions.getQName());
        Iterator itr = definitions.getChildren();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof OMElement)) continue;
            OMElement elt = (OMElement)o;
            if (XMLConfigConstants.SEQUENCE_ELT.equals(elt.getQName())) {
                String key = elt.getAttributeValue(new QName("", "key"));
                if (key != null) {
                    SynapseXMLConfigurationFactory.handleException("Referred sequences are not allowed at the top level");
                    continue;
                }
                SynapseXMLConfigurationFactory.defineSequence(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.ENDPOINT_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineEndpoint(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.ENTRY_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineEntry(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.PROXY_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineProxy(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.REGISTRY_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineRegistry(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.EVENT_SOURCE_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineEventSource(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.EXECUTOR_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineExecutor(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.MESSAGE_STORE_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineMessageStore(config, elt, properties);
                continue;
            }
            if (StartupFinder.getInstance().isStartup(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineStartup(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.DESCRIPTION_ELT.equals(elt.getQName())) {
                config.setDescription(elt.getText());
                continue;
            }
            SynapseXMLConfigurationFactory.handleException("Invalid configuration element at the top level, one of 'sequence', 'endpoint', 'proxy', 'eventSource', 'localEntry', 'priorityExecutor' or 'registry' is expected");
        }
        return config;
    }

    public static Registry defineRegistry(SynapseConfiguration config, OMElement elem, Properties properties) {
        if (config.getRegistry() != null) {
            SynapseXMLConfigurationFactory.handleException("Only one remote registry can be defined within a configuration");
        }
        Registry registry = RegistryFactory.createRegistry(elem, properties);
        config.setRegistry(registry);
        return registry;
    }

    public static Startup defineStartup(SynapseConfiguration config, OMElement elem, Properties properties) {
        Startup startup = StartupFinder.getInstance().getStartup(elem, properties);
        config.addStartup(startup);
        return startup;
    }

    public static ProxyService defineProxy(SynapseConfiguration config, OMElement elem, Properties properties) {
        ProxyService proxy = ProxyServiceFactory.createProxy(elem, properties);
        config.addProxyService(proxy.getName(), proxy);
        return proxy;
    }

    public static Entry defineEntry(SynapseConfiguration config, OMElement elem, Properties properties) {
        Entry entry = EntryFactory.createEntry(elem, properties);
        config.addEntry(entry.getKey(), entry);
        return entry;
    }

    public static Mediator defineSequence(SynapseConfiguration config, OMElement ele, Properties properties) {
        String name = ele.getAttributeValue(new QName("", "name"));
        if (name != null) {
            Mediator mediator = MediatorFactoryFinder.getInstance().getMediator(ele, properties);
            config.addSequence(name, mediator);
            if ("pre-mediate".equals(name)) {
                config.setMandatorySequence(mediator);
            }
            return mediator;
        }
        SynapseXMLConfigurationFactory.handleException("Invalid sequence definition without a name");
        return null;
    }

    public static Endpoint defineEndpoint(SynapseConfiguration config, OMElement ele, Properties properties) {
        String name = ele.getAttributeValue(new QName("", "name"));
        if (name != null) {
            Endpoint endpoint = EndpointFactory.getEndpointFromElement(ele, false, properties);
            config.addEndpoint(name.trim(), endpoint);
            return endpoint;
        }
        SynapseXMLConfigurationFactory.handleException("Invalid endpoint definition without a name");
        return null;
    }

    public static SynapseEventSource defineEventSource(SynapseConfiguration config, OMElement elem, Properties properties) {
        SynapseEventSource eventSource = EventSourceFactory.createEventSource(elem, properties);
        config.addEventSource(eventSource.getName(), eventSource);
        return eventSource;
    }

    public static PriorityExecutor defineExecutor(SynapseConfiguration config, OMElement elem, Properties properties) {
        PriorityExecutor executor = null;
        try {
            executor = PriorityExecutorFactory.createExecutor((String)"http://ws.apache.org/ns/synapse", (OMElement)elem, (boolean)true, (Properties)properties);
        }
        catch (AxisFault axisFault) {
            SynapseXMLConfigurationFactory.handleException("Failed to create the priorityExecutor configuration");
        }
        assert (executor != null);
        config.addPriorityExecutor(executor.getName(), executor);
        return executor;
    }

    public static MessageStore defineMessageStore(SynapseConfiguration config, OMElement elem, Properties properties) {
        MessageStore messageStore = MessageStoreFactory.createMessageStore(elem, properties);
        config.addMessageStore(messageStore.getName(), messageStore);
        return messageStore;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public QName getTagQName() {
        return XMLConfigConstants.DEFINITIONS_ELT;
    }

    public Class getSerializerClass() {
        return SynapseXMLConfigurationSerializer.class;
    }
}

