/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractListMediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.mediators.filters.FilterMediator;

public class FilterMediatorSerializer
extends AbstractListMediatorSerializer {
    protected OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof FilterMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        FilterMediator mediator = (FilterMediator)m;
        OMElement filter = fac.createOMElement("filter", synNS);
        if (mediator.getSource() != null && mediator.getRegex() != null) {
            SynapseXPathSerializer.serializeXPath(mediator.getSource(), filter, "source");
            filter.addAttribute(fac.createOMAttribute("regex", nullNS, mediator.getRegex().pattern()));
        } else if (mediator.getXpath() != null) {
            SynapseXPathSerializer.serializeXPath(mediator.getXpath(), filter, "xpath");
        } else {
            this.handleException("Invalid filter mediator. Should have either a 'source' and a 'regex' OR an 'xpath' ");
        }
        FilterMediatorSerializer.saveTracingState(filter, mediator);
        if (mediator.isThenElementPresent()) {
            OMElement thenElem = fac.createOMElement("then", synNS);
            filter.addChild((OMNode)thenElem);
            if (mediator.getThenKey() != null) {
                thenElem.addAttribute(fac.createOMAttribute("sequence", nullNS, mediator.getThenKey()));
            } else {
                this.serializeChildren(thenElem, mediator.getList());
            }
            if (mediator.getElseMediator() != null || mediator.getElseKey() != null) {
                OMElement elseElem = fac.createOMElement("else", synNS);
                filter.addChild((OMNode)elseElem);
                if (mediator.getElseKey() != null) {
                    elseElem.addAttribute(fac.createOMAttribute("sequence", nullNS, mediator.getElseKey()));
                } else {
                    this.serializeChildren(elseElem, mediator.getElseMediator().getList());
                }
            }
        } else {
            this.serializeChildren(filter, mediator.getList());
        }
        return filter;
    }

    public String getMediatorClassName() {
        return FilterMediator.class.getName();
    }
}

