/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.mediators.builtin.EnqueueMediator;

public class EnqueueMediatorFactory
extends AbstractMediatorFactory {
    public static final QName ENQUEUE_Q = new QName("http://ws.apache.org/ns/synapse", "enqueue");
    public static final QName SEQUENCE_ATT = new QName("sequence");
    public static final QName PRIORITY_ATT = new QName("priority");
    public static final QName QUEUE_ATT = new QName("executor");

    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        OMAttribute queueAtt;
        EnqueueMediator mediator = new EnqueueMediator();
        OMAttribute seqAtt = elem.getAttribute(SEQUENCE_ATT);
        if (seqAtt != null && !"".equals(seqAtt.getAttributeValue())) {
            mediator.setSequenceName(seqAtt.getAttributeValue());
        } else {
            this.handleException("sequence is a required attribue");
        }
        OMAttribute priorityAtt = elem.getAttribute(PRIORITY_ATT);
        if (priorityAtt != null && !"".equals(priorityAtt.getAttributeValue())) {
            mediator.setPriority(Integer.parseInt(priorityAtt.getAttributeValue()));
        }
        if ((queueAtt = elem.getAttribute(QUEUE_ATT)) != null && !"".equals(queueAtt.getAttributeValue())) {
            mediator.setExecutorName(queueAtt.getAttributeValue());
        } else {
            this.handleException("Queue is a required attribue");
        }
        return mediator;
    }

    public QName getTagQName() {
        return ENQUEUE_Q;
    }
}

