/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SequenceMediatorFactory;
import org.apache.synapse.mediators.builtin.CacheMediator;
import org.wso2.caching.digest.DigestGenerator;

public class CacheMediatorFactory
extends AbstractMediatorFactory {
    private static final QName CACHE_Q = new QName("http://ws.apache.org/ns/synapse", "cache");
    private static final QName ATT_ID = new QName("id");
    private static final QName ATT_COLLECTOR = new QName("collector");
    private static final QName ATT_HASH_GENERATOR = new QName("hashGenerator");
    private static final QName ATT_MAX_MSG_SIZE = new QName("maxMessageSize");
    private static final QName ATT_TIMEOUT = new QName("timeout");
    private static final QName ATT_SCOPE = new QName("scope");
    private static final QName ATT_SEQUENCE = new QName("sequence");
    private static final QName ATT_TYPE = new QName("type");
    private static final QName ATT_SIZE = new QName("maxSize");
    private static final QName ON_CACHE_HIT_Q = new QName("http://ws.apache.org/ns/synapse", "onCacheHit");
    private static final QName IMPLEMENTATION_Q = new QName("http://ws.apache.org/ns/synapse", "implementation");
    private static final long DEFAULT_TIMEOUT = 5000L;
    private static final int DEFAULT_DISK_CACHE_SIZE = 200;

    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        OMAttribute scopeAttr;
        if (!CACHE_Q.equals(elem.getQName())) {
            this.handleException("Unable to create the cache mediator. Unexpected element as the cache mediator configuration");
        }
        CacheMediator cache = new CacheMediator();
        OMAttribute idAttr = elem.getAttribute(ATT_ID);
        if (idAttr != null && idAttr.getAttributeValue() != null) {
            cache.setId(idAttr.getAttributeValue());
        }
        if ((scopeAttr = elem.getAttribute(ATT_SCOPE)) != null && scopeAttr.getAttributeValue() != null && this.isValidScope(scopeAttr.getAttributeValue(), cache.getId())) {
            cache.setScope(scopeAttr.getAttributeValue());
        } else {
            cache.setScope("per-host");
        }
        OMAttribute collectorAttr = elem.getAttribute(ATT_COLLECTOR);
        if (collectorAttr != null && collectorAttr.getAttributeValue() != null && "true".equals(collectorAttr.getAttributeValue())) {
            cache.setCollector(true);
        } else {
            OMElement onCacheHitElem;
            OMAttribute timeoutAttr;
            cache.setCollector(false);
            OMAttribute hashGeneratorAttr = elem.getAttribute(ATT_HASH_GENERATOR);
            if (hashGeneratorAttr != null && hashGeneratorAttr.getAttributeValue() != null) {
                try {
                    Class<?> generator = Class.forName(hashGeneratorAttr.getAttributeValue());
                    Object o = generator.newInstance();
                    if (o instanceof DigestGenerator) {
                        cache.setDigestGenerator((DigestGenerator)o);
                    } else {
                        this.handleException("Specified class for the hashGenerator is not a DigestGenerator. It *must* implement org.wso2.caching.digest.DigestGenerator interface");
                    }
                }
                catch (ClassNotFoundException e) {
                    this.handleException("Unable to load the hash generator class", e);
                }
                catch (IllegalAccessException e) {
                    this.handleException("Unable to access the hash generator class", e);
                }
                catch (InstantiationException e) {
                    this.handleException("Unable to instantiate the hash generator class", e);
                }
            }
            if ((timeoutAttr = elem.getAttribute(ATT_TIMEOUT)) != null && timeoutAttr.getAttributeValue() != null) {
                cache.setTimeout(Long.parseLong(timeoutAttr.getAttributeValue()));
            } else {
                cache.setTimeout(5000L);
            }
            OMAttribute maxMessageSizeAttr = elem.getAttribute(ATT_MAX_MSG_SIZE);
            if (maxMessageSizeAttr != null && maxMessageSizeAttr.getAttributeValue() != null) {
                cache.setMaxMessageSize(Integer.parseInt(maxMessageSizeAttr.getAttributeValue()));
            }
            if ((onCacheHitElem = elem.getFirstChildWithName(ON_CACHE_HIT_Q)) != null) {
                OMAttribute sequenceAttr = onCacheHitElem.getAttribute(ATT_SEQUENCE);
                if (sequenceAttr != null && sequenceAttr.getAttributeValue() != null) {
                    cache.setOnCacheHitRef(sequenceAttr.getAttributeValue());
                } else if (onCacheHitElem.getFirstElement() != null) {
                    cache.setOnCacheHitSequence(new SequenceMediatorFactory().createAnonymousSequence(onCacheHitElem, properties));
                }
            }
            Iterator itr = elem.getChildrenWithName(IMPLEMENTATION_Q);
            while (itr.hasNext()) {
                OMElement implElem = (OMElement)itr.next();
                OMAttribute typeAttr = implElem.getAttribute(ATT_TYPE);
                OMAttribute sizeAttr = implElem.getAttribute(ATT_SIZE);
                if (typeAttr == null || typeAttr.getAttributeValue() == null) continue;
                String type = typeAttr.getAttributeValue();
                if ("memory".equals(type) && sizeAttr != null && sizeAttr.getAttributeValue() != null) {
                    cache.setInMemoryCacheSize(Integer.parseInt(sizeAttr.getAttributeValue()));
                    continue;
                }
                if ("disk".equals(type)) {
                    log.warn((Object)"Disk based and hirearchycal caching is not implemented yet");
                    if (sizeAttr != null && sizeAttr.getAttributeValue() != null) {
                        cache.setDiskCacheSize(Integer.parseInt(sizeAttr.getAttributeValue()));
                        continue;
                    }
                    cache.setDiskCacheSize(200);
                    continue;
                }
                this.handleException("unknown implementation type for the Cache mediator");
            }
        }
        return cache;
    }

    private boolean isValidScope(String scope, String id) {
        if ("per-host".equals(scope)) {
            return true;
        }
        if ("per-mediator".equals(scope)) {
            if (id != null) {
                return true;
            }
            this.handleException("Id is required for a cache wirth scope : " + scope);
            return false;
        }
        if ("distributed".equals(scope)) {
            this.handleException("Scope distributed is not supported yet by the Cache mediator");
            return false;
        }
        this.handleException("Unknown scope " + scope + " for the Cache mediator");
        return false;
    }

    public QName getTagQName() {
        return CACHE_Q;
    }
}

