/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.statistics;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.synapse.aspects.statistics.StatisticsRecord;
import org.apache.synapse.aspects.statistics.mbean.StatisticsView;
import org.apache.synapse.commons.jmx.MBeanRegistrar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsCollector {
    private final ConcurrentLinkedQueue<StatisticsRecord> statisticsCollection = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticsCollector() {
        MBeanRegistrar registrar;
        MBeanRegistrar mBeanRegistrar = registrar = MBeanRegistrar.getInstance();
        synchronized (mBeanRegistrar) {
            registrar.registerMBean((Object)new StatisticsView(this), "StatisticsView", "StatisticsView");
        }
    }

    public void collect(StatisticsRecord statisticsRecord) {
        this.statisticsCollection.offer(statisticsRecord);
    }

    public boolean contains(StatisticsRecord statisticsRecord) {
        return this.statisticsCollection.contains(statisticsRecord);
    }

    public void clearStatistics() {
        this.statisticsCollection.clear();
    }

    public List<StatisticsRecord> getStatisticsRecords() {
        ArrayList<StatisticsRecord> records = new ArrayList<StatisticsRecord>();
        records.addAll(this.statisticsCollection);
        return records;
    }

    public List<StatisticsRecord> getAndClearStatisticsRecords() {
        ArrayList<StatisticsRecord> records = new ArrayList<StatisticsRecord>();
        records.addAll(this.statisticsCollection);
        for (StatisticsRecord record : records) {
            this.statisticsCollection.remove(record);
        }
        return records;
    }
}

