/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.WSDL20DefaultValueHolder;
import org.apache.axis2.dispatchers.RequestURIBasedDispatcher;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;
import org.apache.http.Header;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;

public class RESTUtil {
    public static String getURI(MessageContext messageContext, String address) throws AxisFault {
        address = address.substring(address.indexOf("//") + 2);
        address = address.substring(address.indexOf("/"));
        String queryParameterSeparator = (String)messageContext.getProperty("whttp:queryParameterSeparator");
        if (queryParameterSeparator == null) {
            queryParameterSeparator = WSDL20DefaultValueHolder.getDefaultValue((String)"whttp:queryParameterSeparator");
        }
        OMElement firstElement = messageContext.getEnvelope().getBody().getFirstElement();
        String params = "";
        if (firstElement != null) {
            address = address + "/" + firstElement.getLocalName();
        } else {
            firstElement = messageContext.getEnvelope().getBody();
        }
        Iterator iter = firstElement.getChildElements();
        String legalCharacters = "-._~!$'()*+,;=:@/?".replaceAll(queryParameterSeparator, "");
        StringBuffer buff = new StringBuffer(params);
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            try {
                buff.append(URIEncoderDecoder.quoteIllegal((String)element.getLocalName(), (String)legalCharacters)).append("=").append(URIEncoderDecoder.quoteIllegal((String)element.getText(), (String)legalCharacters)).append(queryParameterSeparator);
            }
            catch (UnsupportedEncodingException e) {
                throw new AxisFault("URI Encoding error : " + element.getLocalName() + "=" + element.getText(), (Throwable)e);
            }
        }
        params = buff.toString();
        if (params.trim().length() != 0) {
            int index = address.indexOf("?");
            address = index == -1 ? address + "?" + params.substring(0, params.length() - 1) : (index == address.length() - 1 ? address + params.substring(0, params.length() - 1) : address + queryParameterSeparator + params.substring(0, params.length() - 1));
        }
        return address;
    }

    public static void processGetAndDeleteRequest(MessageContext msgContext, OutputStream out, String requestURI, Header contentTypeHeader, String httpMethod) throws AxisFault {
        String contentType = contentTypeHeader != null ? contentTypeHeader.getValue() : null;
        RESTUtil.prepareMessageContext(msgContext, requestURI, httpMethod, out, contentType);
        msgContext.setProperty("NO_ENTITY_BODY", (Object)Boolean.TRUE);
        org.apache.axis2.transport.http.util.RESTUtil.processURLRequest((MessageContext)msgContext, (OutputStream)out, (String)contentType);
    }

    public static void processURLRequest(MessageContext msgContext, OutputStream out, String soapAction, String requestURI) throws AxisFault {
        if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        msgContext.setSoapAction(soapAction);
        msgContext.setTo(new EndpointReference(requestURI));
        msgContext.setProperty("TRANSPORT_OUT", (Object)out);
        msgContext.setServerSide(true);
        msgContext.setDoingREST(true);
        msgContext.setEnvelope(new SOAP11Factory().getDefaultEnvelope());
        msgContext.setProperty("NO_ENTITY_BODY", (Object)Boolean.TRUE);
        AxisEngine.receive((MessageContext)msgContext);
    }

    public static void processPOSTRequest(MessageContext msgContext, InputStream is, OutputStream os, String requestURI, Header contentTypeHeader) throws AxisFault {
        String contentType = contentTypeHeader != null ? contentTypeHeader.getValue() : null;
        RESTUtil.prepareMessageContext(msgContext, requestURI, "POST", os, contentType);
        org.apache.axis2.transport.http.util.RESTUtil.processXMLRequest((MessageContext)msgContext, (InputStream)is, (OutputStream)os, (String)contentType);
    }

    private static void prepareMessageContext(MessageContext msgContext, String requestURI, String httpMethod, OutputStream out, String contentType) throws AxisFault {
        msgContext.setTo(new EndpointReference(requestURI));
        msgContext.setProperty("HTTP_METHOD_OBJECT", (Object)httpMethod);
        msgContext.setServerSide(true);
        msgContext.setDoingREST(true);
        msgContext.setProperty("TRANSPORT_OUT", (Object)out);
        msgContext.setProperty("synapse.internal.rest.contentType", (Object)contentType);
        RequestURIBasedDispatcher requestDispatcher = new RequestURIBasedDispatcher();
        AxisService axisService = requestDispatcher.findService(msgContext);
        if (axisService == null) {
            String defaultSvcName = NHttpConfiguration.getInstance().getStringValue("nhttp.default.service", "__SynapseService");
            axisService = msgContext.getConfigurationContext().getAxisConfiguration().getService(defaultSvcName);
        }
        msgContext.setAxisService(axisService);
    }
}

