/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import org.apache.axis2.transport.base.MetricsCollector;
import org.apache.synapse.transport.nhttp.util.ConnectionsView;

public class NhttpMetricsCollector
extends MetricsCollector {
    private ConnectionsView view;
    private boolean listener;

    public NhttpMetricsCollector(boolean listener, boolean isHttps) {
        this.listener = listener;
        String name = "http" + (isHttps ? "s" : "") + "-" + (listener ? "listener" : "sender");
        this.view = new ConnectionsView(name);
    }

    public void destroy() {
        this.view.destroy();
    }

    public void connected() {
        this.view.connected();
    }

    public void disconnected() {
        this.view.disconnected();
    }

    public void notifyReceivedMessageSize(long l) {
        super.notifyReceivedMessageSize(l);
        if (l > 0L) {
            this.view.notifyMessageSize(l, this.listener);
        }
    }

    public void notifySentMessageSize(long l) {
        super.notifySentMessageSize(l);
        if (l > 0L) {
            this.view.notifyMessageSize(l, !this.listener);
        }
    }
}

