/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.debug;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.synapse.transport.nhttp.debug.NhttpConnectionDebugConfig;

public abstract class AbstractConnectionDebug {
    protected final DateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");
    protected String keyValueSeparator;
    protected String fieldSeparator;
    protected String statementSeparator;
    protected boolean printAllHeaders;
    protected boolean printNoHeaders;
    protected List<String> printHeaderNames;
    protected Header[] headers;

    protected AbstractConnectionDebug() {
        NhttpConnectionDebugConfig connDebugConfig = NhttpConnectionDebugConfig.getInstance();
        this.keyValueSeparator = connDebugConfig.getKeyValueSeparator();
        this.fieldSeparator = connDebugConfig.getFieldSeparator();
        this.statementSeparator = connDebugConfig.getStatementSeparator();
        if (connDebugConfig.isNoHeaders()) {
            this.printNoHeaders = true;
        } else if (connDebugConfig.isAllHeaders()) {
            this.printAllHeaders = true;
        } else {
            this.printHeaderNames = connDebugConfig.getHeaders();
        }
    }

    protected String format(long ms) {
        return this.formatter.format(new Date(ms));
    }

    public abstract String dump();

    protected StringBuffer headersToString() {
        StringBuffer sb;
        block6: {
            block7: {
                sb = new StringBuffer();
                if (this.headers == null) break block6;
                if (!this.printAllHeaders) break block7;
                boolean first = true;
                for (Header h : this.headers) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(this.fieldSeparator);
                    }
                    sb.append(h.getName()).append(this.keyValueSeparator).append(h.getValue());
                }
                break block6;
            }
            if (this.printHeaderNames == null) break block6;
            boolean first = true;
            for (Header h : this.headers) {
                if (!this.printHeaderNames.contains(h.getName())) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(this.fieldSeparator);
                }
                sb.append(h.getName()).append(this.keyValueSeparator).append(h.getValue());
            }
        }
        return sb.length() > 0 ? sb : sb.append("NOT_AVAILABLE");
    }
}

