/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.saaj.util.SAAJUtil;
import org.w3c.dom.Element;

public class SOAPMessageHelper {
    public static SOAPEnvelope cloneSOAPEnvelope(SOAPEnvelope envelope) {
        Iterator itr;
        SOAPEnvelope newEnvelope = "http://schemas.xmlsoap.org/soap/envelope/".equals(envelope.getBody().getNamespace().getNamespaceURI()) ? OMAbstractFactory.getSOAP11Factory().getDefaultEnvelope() : OMAbstractFactory.getSOAP12Factory().getDefaultEnvelope();
        if (envelope.getHeader() != null) {
            itr = envelope.getHeader().cloneOMElement().getChildren();
            while (itr.hasNext()) {
                newEnvelope.getHeader().addChild((OMNode)itr.next());
            }
        }
        if (envelope.getBody() != null) {
            itr = envelope.getBody().cloneOMElement().getChildren();
            while (itr.hasNext()) {
                newEnvelope.getBody().addChild((OMNode)itr.next());
            }
        }
        return newEnvelope;
    }

    public static SOAPEnvelope buildSOAPEnvelopeFromBytes(byte[] data) throws SOAPException, IOException {
        MessageFactory mf = MessageFactory.newInstance();
        SOAPMessage smsg = mf.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(data));
        return SAAJUtil.toOMSOAPEnvelope((Element)smsg.getSOAPPart().getDocumentElement());
    }
}

