/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.context.AbstractContext;
import org.wso2.caching.CachedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManager
implements Serializable {
    private Map<String, Set<String>> cache = new ConcurrentHashMap<String, Set<String>>();

    public synchronized void resetCache(String service, AbstractContext context) {
        this.removeCachedObjects(service, context);
    }

    public synchronized void removeExpiredResponses(String service, AbstractContext context) {
        Set<String> keySet = this.getCacheKeys(service);
        Iterator<String> itr = keySet.iterator();
        while (itr.hasNext()) {
            CachedObject cachedObj;
            String key = itr.next().toString();
            Object o = context.getProperty(service + "/" + key);
            if (o == null || !(o instanceof CachedObject) || !(cachedObj = (CachedObject)o).isExpired()) continue;
            itr.remove();
            context.removeProperty(service + "/" + key);
        }
    }

    public CachedObject getResponseForKey(String service, String key, AbstractContext context) {
        Set<String> keySet = this.getCacheKeys(service);
        if (keySet.contains(key)) {
            Object obj = context.getProperty(service + "/" + key);
            return obj instanceof CachedObject ? (CachedObject)obj : null;
        }
        return null;
    }

    public void addResponseWithKey(String service, String key, CachedObject response, AbstractContext context) {
        context.setProperty(service + "/" + key, (Object)response);
        Set<String> keySet = this.getCacheKeys(service);
        keySet.add(key);
    }

    public boolean containsKey(String service, String key) {
        Set<String> keySet = this.cache.get(service);
        return keySet != null && keySet.contains(key);
    }

    public Set<String> getCacheKeys(String service) {
        if (!this.cache.containsKey(service)) {
            this.cache.put(service, new HashSet());
        }
        return this.cache.get(service);
    }

    private synchronized void removeCachedObjects(String service, AbstractContext context) {
        Set<String> keySet = this.getCacheKeys(service);
        for (String key : keySet) {
            context.removeProperty(service + "/" + key);
        }
        keySet.clear();
    }
}

