/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy12.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.Layout;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.TransportBinding;
import org.apache.ws.secpolicy.model.TransportToken;

public class TransportBindingBuilder
implements AssertionBuilder {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        TransportBinding transportBinding = new TransportBinding(2);
        Policy policy = PolicyEngine.getPolicy((OMElement)element.getFirstElement());
        Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), transportBinding, factory);
        }
        return transportBinding;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.TRANSPORT_BINDING};
    }

    private void processAlternative(List assertionList, TransportBinding parent, AssertionBuilderFactory factory) {
        for (Assertion primitive : assertionList) {
            QName name = primitive.getName();
            if (name.equals(SP12Constants.ALGORITHM_SUITE)) {
                parent.setAlgorithmSuite((AlgorithmSuite)primitive);
                continue;
            }
            if (name.equals(SP12Constants.TRANSPORT_TOKEN)) {
                parent.setTransportToken((TransportToken)primitive);
                continue;
            }
            if (name.equals(SP12Constants.INCLUDE_TIMESTAMP)) {
                parent.setIncludeTimestamp(true);
                continue;
            }
            if (name.equals(SP12Constants.LAYOUT)) {
                parent.setLayout((Layout)primitive);
                continue;
            }
            if (name.equals(SP12Constants.PROTECT_TOKENS)) {
                parent.setTokenProtection(true);
                continue;
            }
            if (name.equals(SP12Constants.SIGNED_SUPPORTING_TOKENS)) {
                parent.setSignedSupportingToken((SupportingToken)primitive);
                continue;
            }
            if (!name.equals(SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS)) continue;
            parent.setSignedEndorsingSupportingTokens((SupportingToken)primitive);
        }
    }
}

