/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.format;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axis2.format.TextFromElementReader;

public class ElementHelper {
    private ElementHelper() {
    }

    public static Reader getTextAsStream(OMElement element, boolean cache) {
        if (!(element instanceof OMSourcedElement || cache && !element.isComplete())) {
            OMNode child = element.getFirstOMChild();
            if (child == null) {
                return new StringReader("");
            }
            if (child.getNextOMSibling() == null) {
                return new StringReader(child instanceof OMText ? ((OMText)child).getText() : "");
            }
        }
        return new TextFromElementReader(cache ? element.getXMLStreamReader() : element.getXMLStreamReaderWithoutCaching());
    }

    public static void writeTextTo(OMElement element, Writer out, boolean cache) throws XMLStreamException, IOException {
        XMLStreamReader reader = cache ? element.getXMLStreamReader() : element.getXMLStreamReaderWithoutCaching();
        int depth = 0;
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 4: 
                case 12: {
                    if (depth != 1) break;
                    out.write(reader.getText());
                    break;
                }
                case 1: {
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
        }
    }
}

