/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.invokers;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.java.invokers.RubyToJavaInvoker;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorInvoker
extends RubyToJavaInvoker {
    private Constructor[] ctors;

    public ConstructorInvoker(RubyModule host, List<Constructor> methods2) {
        super(host);
        this.ctors = methods2.toArray(new Constructor[methods2.size()]);
        if (!Ruby.isSecurityRestricted()) {
            try {
                Method.setAccessible(this.ctors, true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    synchronized void createJavaCallables(Ruby runtime2) {
        if (!this.initialized) {
            if (this.ctors != null) {
                if (this.ctors.length == 1) {
                    this.javaCallable = JavaConstructor.create(runtime2, this.ctors[0]);
                } else {
                    HashMap<Integer, ArrayList<JavaConstructor>> methodsMap = new HashMap<Integer, ArrayList<JavaConstructor>>();
                    int maxArity = 0;
                    for (Constructor ctor : this.ctors) {
                        int arity2 = ctor.getParameterTypes().length;
                        maxArity = Math.max(arity2, maxArity);
                        ArrayList<JavaConstructor> methodsForArity = (ArrayList<JavaConstructor>)methodsMap.get(arity2);
                        if (methodsForArity == null) {
                            methodsForArity = new ArrayList<JavaConstructor>();
                            methodsMap.put(arity2, methodsForArity);
                        }
                        methodsForArity.add(JavaConstructor.create(runtime2, ctor));
                    }
                    this.javaCallables = new JavaConstructor[maxArity + 1][];
                    for (Map.Entry entry : methodsMap.entrySet()) {
                        List ctorsForArity = (List)entry.getValue();
                        JavaConstructor[] methodsArray = ctorsForArity.toArray(new JavaConstructor[ctorsForArity.size()]);
                        this.javaCallables[((Integer)entry.getKey()).intValue()] = methodsArray;
                    }
                }
                this.ctors = null;
                this.cache = new ConcurrentHashMap();
            }
            this.initialized = true;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
        this.createJavaCallables(self.getRuntime());
        int len = args2.length;
        Object[] convertedArgs = new Object[len];
        JavaConstructor callable = (JavaConstructor)this.findCallable(self, name2, args2, len);
        Class<?>[] targetTypes = callable.getParameterTypes();
        int i = len;
        while (--i >= 0) {
            convertedArgs[i] = JavaUtil.convertArgumentToType(context, args2[i], targetTypes[i]);
        }
        Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
        return self;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
        this.createJavaCallables(self.getRuntime());
        JavaConstructor callable = (JavaConstructor)this.findCallableArityZero(self, name2);
        Java.JavaUtilities.set_java_object(self, self, callable.new_instance(EMPTY_OBJECT_ARRAY));
        return self;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
        this.createJavaCallables(self.getRuntime());
        Object[] convertedArgs = new Object[1];
        JavaConstructor callable = (JavaConstructor)this.findCallableArityOne(self, name2, arg0);
        convertedArgs[0] = JavaUtil.convertArgumentToType(context, arg0, callable.getParameterTypes()[0]);
        Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
        return self;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        this.createJavaCallables(self.getRuntime());
        Object[] convertedArgs = new Object[2];
        JavaConstructor callable = (JavaConstructor)this.findCallableArityTwo(self, name2, arg0, arg1);
        convertedArgs[0] = JavaUtil.convertArgumentToType(context, arg0, callable.getParameterTypes()[0]);
        convertedArgs[1] = JavaUtil.convertArgumentToType(context, arg1, callable.getParameterTypes()[1]);
        Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
        return self;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        this.createJavaCallables(self.getRuntime());
        Object[] convertedArgs = new Object[3];
        JavaConstructor callable = (JavaConstructor)this.findCallableArityThree(self, name2, arg0, arg1, arg2);
        convertedArgs[0] = JavaUtil.convertArgumentToType(context, arg0, callable.getParameterTypes()[0]);
        convertedArgs[1] = JavaUtil.convertArgumentToType(context, arg1, callable.getParameterTypes()[1]);
        convertedArgs[2] = JavaUtil.convertArgumentToType(context, arg2, callable.getParameterTypes()[2]);
        Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
        return self;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        this.createJavaCallables(self.getRuntime());
        if (block.isGiven()) {
            int len = args2.length;
            Object[] convertedArgs = new Object[len + 1];
            IRubyObject[] intermediate = new IRubyObject[len + 1];
            System.arraycopy(args2, 0, intermediate, 0, len);
            intermediate[len] = RubyProc.newProc(self.getRuntime(), block, Block.Type.LAMBDA);
            JavaConstructor callable = (JavaConstructor)this.findCallable(self, name2, intermediate, len + 1);
            for (int i = 0; i < len + 1; ++i) {
                convertedArgs[i] = JavaUtil.convertArgumentToType(context, intermediate[i], callable.getParameterTypes()[i]);
            }
            Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
            return self;
        }
        return this.call(context, self, clazz, name2, args2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
        this.createJavaCallables(self.getRuntime());
        if (block.isGiven()) {
            Object[] convertedArgs = new Object[1];
            RubyProc proc2 = RubyProc.newProc(self.getRuntime(), block, Block.Type.LAMBDA);
            JavaConstructor callable = (JavaConstructor)this.findCallableArityOne(self, name2, proc2);
            convertedArgs[0] = JavaUtil.convertArgumentToType(context, proc2, callable.getParameterTypes()[0]);
            Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
            return self;
        }
        return this.call(context, self, clazz, name2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        this.createJavaCallables(self.getRuntime());
        if (block.isGiven()) {
            Object[] convertedArgs = new Object[2];
            RubyProc proc2 = RubyProc.newProc(self.getRuntime(), block, Block.Type.LAMBDA);
            JavaConstructor callable = (JavaConstructor)this.findCallableArityTwo(self, name2, arg0, proc2);
            convertedArgs[0] = JavaUtil.convertArgumentToType(context, arg0, callable.getParameterTypes()[0]);
            convertedArgs[1] = JavaUtil.convertArgumentToType(context, proc2, callable.getParameterTypes()[1]);
            Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
            return self;
        }
        return this.call(context, self, clazz, name2, arg0);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        this.createJavaCallables(self.getRuntime());
        if (block.isGiven()) {
            Object[] convertedArgs = new Object[3];
            RubyProc proc2 = RubyProc.newProc(self.getRuntime(), block, Block.Type.LAMBDA);
            JavaConstructor callable = (JavaConstructor)this.findCallableArityThree(self, name2, arg0, arg1, proc2);
            convertedArgs[0] = JavaUtil.convertArgumentToType(context, arg0, callable.getParameterTypes()[0]);
            convertedArgs[1] = JavaUtil.convertArgumentToType(context, arg1, callable.getParameterTypes()[1]);
            convertedArgs[2] = JavaUtil.convertArgumentToType(context, proc2, callable.getParameterTypes()[2]);
            Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
            return self;
        }
        return this.call(context, self, clazz, name2, arg0, arg1);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        this.createJavaCallables(self.getRuntime());
        if (block.isGiven()) {
            Object[] convertedArgs = new Object[4];
            RubyProc proc2 = RubyProc.newProc(self.getRuntime(), block, Block.Type.LAMBDA);
            JavaConstructor callable = (JavaConstructor)this.findCallableArityFour(self, name2, arg0, arg1, arg2, proc2);
            convertedArgs[0] = JavaUtil.convertArgumentToType(context, arg0, callable.getParameterTypes()[0]);
            convertedArgs[1] = JavaUtil.convertArgumentToType(context, arg1, callable.getParameterTypes()[1]);
            convertedArgs[2] = JavaUtil.convertArgumentToType(context, arg2, callable.getParameterTypes()[2]);
            convertedArgs[3] = JavaUtil.convertArgumentToType(context, proc2, callable.getParameterTypes()[3]);
            Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
            return self;
        }
        return this.call(context, self, clazz, name2, arg0, arg1, arg2);
    }
}

