/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import org.jruby.Ruby;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;

class BoundedNativeMemoryIO
implements MemoryIO,
DirectMemoryIO {
    protected static final com.kenai.jffi.MemoryIO IO = com.kenai.jffi.MemoryIO.getInstance();
    protected static final int LONG_SIZE = Platform.getPlatform().longSize();
    protected static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
    private final Ruby runtime;
    final long address;
    final long size;
    final BoundedNativeMemoryIO parent;

    BoundedNativeMemoryIO(Ruby runtime2, long address2, int size2) {
        this.runtime = runtime2;
        this.address = address2;
        this.size = size2;
        this.parent = null;
    }

    private BoundedNativeMemoryIO(BoundedNativeMemoryIO parent, long offset2) {
        this.runtime = parent.runtime;
        this.address = parent.address + offset2;
        this.size = parent.size - offset2;
        this.parent = parent;
    }

    private final void checkBounds(long off, long len) {
        Util.checkBounds(this.runtime, this.size, off, len);
    }

    public final long getAddress() {
        return this.address;
    }

    public BoundedNativeMemoryIO slice(long offset2) {
        this.checkBounds(offset2, 1L);
        return offset2 == 0L ? this : new BoundedNativeMemoryIO(this, offset2);
    }

    public final boolean equals(Object obj) {
        return obj instanceof DirectMemoryIO && ((DirectMemoryIO)obj).getAddress() == this.address;
    }

    public final int hashCode() {
        int hash2 = 5;
        hash2 = 53 * hash2 + (int)(this.address ^ this.address >>> 32);
        return hash2;
    }

    public final boolean isNull() {
        return this.address == 0L;
    }

    public final boolean isDirect() {
        return true;
    }

    public final byte getByte(long offset2) {
        this.checkBounds(offset2, 1L);
        return IO.getByte(this.address + offset2);
    }

    public final short getShort(long offset2) {
        this.checkBounds(offset2, 2L);
        return IO.getShort(this.address + offset2);
    }

    public final int getInt(long offset2) {
        this.checkBounds(offset2, 4L);
        return IO.getInt(this.address + offset2);
    }

    public final long getLong(long offset2) {
        this.checkBounds(offset2, 8L);
        return IO.getLong(this.address + offset2);
    }

    public final long getNativeLong(long offset2) {
        return LONG_SIZE == 32 ? (long)this.getInt(offset2) : this.getLong(offset2);
    }

    public final float getFloat(long offset2) {
        this.checkBounds(offset2, 4L);
        return IO.getFloat(this.address + offset2);
    }

    public final double getDouble(long offset2) {
        this.checkBounds(offset2, 8L);
        return IO.getDouble(this.address + offset2);
    }

    public final long getAddress(long offset2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        return IO.getAddress(this.address + offset2);
    }

    public final DirectMemoryIO getMemoryIO(long offset2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        long ptr = IO.getAddress(this.address + offset2);
        return ptr != 0L ? new NativeMemoryIO(ptr) : null;
    }

    public final void putByte(long offset2, byte value2) {
        this.checkBounds(offset2, 1L);
        IO.putByte(this.address + offset2, value2);
    }

    public final void putShort(long offset2, short value2) {
        this.checkBounds(offset2, 2L);
        IO.putShort(this.address + offset2, value2);
    }

    public final void putInt(long offset2, int value2) {
        this.checkBounds(offset2, 4L);
        IO.putInt(this.address + offset2, value2);
    }

    public final void putLong(long offset2, long value2) {
        this.checkBounds(offset2, 8L);
        IO.putLong(this.address + offset2, value2);
    }

    public final void putNativeLong(long offset2, long value2) {
        if (LONG_SIZE == 32) {
            this.putInt(offset2, (int)value2);
        } else {
            this.putLong(offset2, value2);
        }
    }

    public final void putAddress(long offset2, long value2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        IO.putAddress(this.address + offset2, value2);
    }

    public final void putFloat(long offset2, float value2) {
        this.checkBounds(offset2, 4L);
        IO.putFloat(this.address + offset2, value2);
    }

    public final void putDouble(long offset2, double value2) {
        this.checkBounds(offset2, 8L);
        IO.putDouble(this.address + offset2, value2);
    }

    public final void putMemoryIO(long offset2, MemoryIO value2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        IO.putAddress(this.address + offset2, ((DirectMemoryIO)value2).getAddress());
    }

    public final void get(long offset2, byte[] dst, int off, int len) {
        this.checkBounds(offset2, len);
        IO.getByteArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, byte[] src, int off, int len) {
        this.checkBounds(offset2, len);
        IO.putByteArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, short[] dst, int off, int len) {
        this.checkBounds(offset2, len << 1);
        IO.getShortArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, short[] src, int off, int len) {
        this.checkBounds(offset2, len << 1);
        IO.putShortArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, int[] dst, int off, int len) {
        this.checkBounds(offset2, len << 2);
        IO.getIntArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, int[] src, int off, int len) {
        this.checkBounds(offset2, len << 2);
        IO.putIntArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, long[] dst, int off, int len) {
        this.checkBounds(offset2, len << 3);
        IO.getLongArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, long[] src, int off, int len) {
        this.checkBounds(offset2, len << 3);
        IO.putLongArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, float[] dst, int off, int len) {
        this.checkBounds(offset2, len << 2);
        IO.getFloatArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, float[] src, int off, int len) {
        this.checkBounds(offset2, len << 2);
        IO.putFloatArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, double[] dst, int off, int len) {
        this.checkBounds(offset2, len << 3);
        IO.getDoubleArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, double[] src, int off, int len) {
        this.checkBounds(offset2, len << 3);
        IO.putDoubleArray(this.address + offset2, src, off, len);
    }

    public final int indexOf(long offset2, byte value2) {
        return value2 == 0 ? (int)IO.getStringLength(this.address + offset2) : (int)IO.indexOf(this.address + offset2, value2);
    }

    public final int indexOf(long offset2, byte value2, int maxlen) {
        return (int)IO.indexOf(this.address, value2, maxlen);
    }

    public final void setMemory(long offset2, long size2, byte value2) {
        this.checkBounds(offset2, size2);
        IO.setMemory(this.address + offset2, size2, value2);
    }

    public final byte[] getZeroTerminatedByteArray(long offset2) {
        this.checkBounds(offset2, 1L);
        return FFIUtil.getZeroTerminatedByteArray(this.address + offset2);
    }

    public final byte[] getZeroTerminatedByteArray(long offset2, int maxlen) {
        this.checkBounds(offset2, 1L);
        return FFIUtil.getZeroTerminatedByteArray(this.address + offset2, Math.min(maxlen, (int)(this.size - offset2)));
    }

    public void putZeroTerminatedByteArray(long offset2, byte[] bytes2, int off, int len) {
        this.checkBounds(offset2, len + 1);
        FFIUtil.putZeroTerminatedByteArray(this.address + offset2, bytes2, off, len);
    }
}

