/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

final class TypeSizeMapper {
    private static final int[] sizes;

    TypeSizeMapper() {
    }

    private static final int getTypeSize(IRubyObject type2) {
        int index2 = NativeType.valueOf(type2).ordinal();
        return index2 >= 0 && index2 < sizes.length ? sizes[index2] : -1;
    }

    private static final int callTypeSize(ThreadContext context, RubyModule ffi2, IRubyObject sizeArg) {
        return TypeSizeMapper.getTypeSize(ffi2.callMethod(context, "type_size", sizeArg));
    }

    public static final int getTypeSize(ThreadContext context, IRubyObject sizeArg) {
        RubyModule ffi2 = context.getRuntime().fastGetModule("FFI");
        IRubyObject typeDefs = ffi2.fastFetchConstant("TypeDefs");
        IRubyObject type2 = ((RubyHash)typeDefs).fastARef(sizeArg);
        int size2 = type2 != null && !type2.isNil() ? TypeSizeMapper.getTypeSize(type2) : 0;
        return size2 > 0 ? size2 : TypeSizeMapper.callTypeSize(context, ffi2, sizeArg);
    }

    static {
        NativeType[] types = NativeType.values();
        int[] sz = new int[types.length];
        block8: for (int i = 0; i < sz.length; ++i) {
            switch (types[i]) {
                case INT8: 
                case UINT8: {
                    sz[types[i].ordinal()] = 1;
                    continue block8;
                }
                case INT16: 
                case UINT16: {
                    sz[types[i].ordinal()] = 2;
                    continue block8;
                }
                case INT32: 
                case UINT32: 
                case FLOAT32: {
                    sz[types[i].ordinal()] = 4;
                    continue block8;
                }
                case INT64: 
                case UINT64: 
                case FLOAT64: {
                    sz[types[i].ordinal()] = 8;
                    continue block8;
                }
                case LONG: 
                case ULONG: {
                    sz[types[i].ordinal()] = Platform.getPlatform().longSize() >> 3;
                    continue block8;
                }
                case POINTER: {
                    sz[types[i].ordinal()] = Platform.getPlatform().addressSize() >> 3;
                    continue block8;
                }
                default: {
                    sz[types[i].ordinal()] = -1;
                }
            }
        }
        sizes = sz;
    }
}

