/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.NativeParam;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Type;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::CallbackInfo"}, parent="FFI::Type")
public class CallbackInfo
extends Type
implements NativeParam {
    public static final String CLASS_NAME = "CallbackInfo";
    protected final Arity arity;
    protected final Type[] parameterTypes;
    protected final Type returnType;

    public static RubyClass createCallbackInfoClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder(CLASS_NAME, module.fastGetClass("Type"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(CallbackInfo.class);
        result.defineAnnotatedConstants(CallbackInfo.class);
        return result;
    }

    public CallbackInfo(Ruby runtime2, RubyClass klazz, Type returnType, Type[] paramTypes) {
        super(runtime2, klazz, NativeType.POINTER);
        this.arity = Arity.fixed(paramTypes.length);
        this.parameterTypes = paramTypes;
        this.returnType = returnType;
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static final IRubyObject newCallbackInfo(ThreadContext context, IRubyObject klass, IRubyObject returnType, IRubyObject paramTypes) {
        if (!(returnType instanceof Type)) {
            throw context.getRuntime().newArgumentError("wrong argument type " + returnType.getMetaClass().getName() + " (expected FFI::Type)");
        }
        if (!(paramTypes instanceof RubyArray)) {
            throw context.getRuntime().newArgumentError("wrong argument type " + paramTypes.getMetaClass().getName() + " (expected Array)");
        }
        Type[] nativeParamTypes = new Type[((RubyArray)paramTypes).size()];
        for (int i = 0; i < nativeParamTypes.length; ++i) {
            IRubyObject obj = ((RubyArray)paramTypes).entry(i);
            if (!(obj instanceof Type)) {
                throw context.getRuntime().newArgumentError("wrong argument type " + obj.getMetaClass().getName() + " (expected array of FFI::Type)");
            }
            nativeParamTypes[i] = (Type)obj;
        }
        try {
            return new CallbackInfo(context.getRuntime(), (RubyClass)klass, (Type)returnType, nativeParamTypes);
        }
        catch (UnsatisfiedLinkError ex) {
            return context.getRuntime().getNil();
        }
    }

    public final Arity getArity() {
        return this.arity;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    public final Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    @JRubyMethod(name={"to_s"})
    public final IRubyObject to_s(ThreadContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("#<FFI::CallbackInfo [ ");
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            sb.append(this.parameterTypes[i].toString().toLowerCase());
            if (i >= this.parameterTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(" ], " + this.returnType.toString().toLowerCase() + ">");
        return context.getRuntime().newString(sb.toString());
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CallbackInfo[parameters=[");
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            sb.append(this.parameterTypes[i].toString().toLowerCase());
            if (i >= this.parameterTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append("] return=" + this.returnType.toString().toLowerCase() + "]");
        return sb.toString();
    }
}

