/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelStream;

@JRubyClass(name={"Net::BufferedIO"})
public class NetProtocolBufferedIO {
    public static void create(Ruby runtime2) {
        RubyModule mNet = runtime2.getModule("Net");
        RubyClass cBufferedIO = (RubyClass)mNet.getConstant("BufferedIO");
        cBufferedIO.defineAnnotatedMethods(NetProtocolBufferedIO.class);
        RubyModule mNativeImpl = cBufferedIO.defineModuleUnder("NativeImplementation");
        mNativeImpl.defineAnnotatedMethods(NativeImpl.class);
    }

    @JRubyMethod(required=1)
    public static IRubyObject initialize(IRubyObject recv2, IRubyObject io2) {
        if (io2 instanceof RubyIO && ((RubyIO)io2).getOpenFile().getMainStream() instanceof ChannelStream && ((ChannelStream)((RubyIO)io2).getOpenFile().getMainStream()).getDescriptor().getChannel() instanceof SelectableChannel) {
            ((RubyObject)recv2).extend(new IRubyObject[]{((RubyModule)recv2.getRuntime().getModule("Net").getConstant("BufferedIO")).getConstant("NativeImplementation")});
            SelectableChannel sc = (SelectableChannel)((ChannelStream)((RubyIO)io2).getOpenFile().getMainStream()).getDescriptor().getChannel();
            recv2.dataWrapStruct(new NativeImpl(sc));
        }
        recv2.getInstanceVariables().setInstanceVariable("@io", io2);
        recv2.getInstanceVariables().setInstanceVariable("@read_timeout", recv2.getRuntime().newFixnum(60));
        recv2.getInstanceVariables().setInstanceVariable("@debug_output", recv2.getRuntime().getNil());
        recv2.getInstanceVariables().setInstanceVariable("@rbuf", RubyString.newEmptyString(recv2.getRuntime()));
        return recv2;
    }

    @JRubyModule(name={"Net::BufferedIO::NativeImplementation"})
    public static class NativeImpl {
        private SelectableChannel channel;

        public NativeImpl(SelectableChannel channel) {
            this.channel = channel;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @JRubyMethod
        public static IRubyObject rbuf_fill(IRubyObject recv2) {
            RubyString buf = (RubyString)recv2.getInstanceVariables().getInstanceVariable("@rbuf");
            RubyIO io2 = (RubyIO)recv2.getInstanceVariables().getInstanceVariable("@io");
            int timeout2 = RubyNumeric.fix2int(recv2.getInstanceVariables().getInstanceVariable("@read_timeout")) * 1000;
            NativeImpl nim = (NativeImpl)recv2.dataGetStruct();
            Selector selector = null;
            Object object = nim.channel.blockingLock();
            synchronized (object) {
                RubyString rubyString;
                boolean oldBlocking;
                block18: {
                    oldBlocking = nim.channel.isBlocking();
                    try {
                        selector = Selector.open();
                        nim.channel.configureBlocking(false);
                        SelectionKey key2 = nim.channel.register(selector, 1);
                        int n = selector.select(timeout2);
                        if (n > 0) {
                            IRubyObject readItems = io2.read(new IRubyObject[]{recv2.getRuntime().newFixnum(16384)});
                            rubyString = buf.concat(readItems);
                            break block18;
                        }
                        RubyClass exc = (RubyClass)recv2.getRuntime().getModule("Timeout").getConstant("Error");
                        throw new RaiseException(RubyException.newException(recv2.getRuntime(), exc, "execution expired"), false);
                    }
                    catch (IOException exception2) {
                        throw recv2.getRuntime().newIOErrorFromException(exception2);
                    }
                }
                return rubyString;
                finally {
                    if (selector != null) {
                        try {
                            selector.close();
                        }
                        catch (Exception e) {}
                    }
                    try {
                        nim.channel.configureBlocking(oldBlocking);
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }
}

