/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.mop.beans;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import org.dynalang.mop.BaseMetaobjectProtocol;
import org.dynalang.mop.CallProtocol;
import org.dynalang.mop.beans.DynamicMethod;

class SimpleDynamicMethod
extends DynamicMethod {
    private final Method method;
    private final Class[] paramTypes;

    SimpleDynamicMethod(Method method2) {
        this.method = method2;
        this.paramTypes = method2.getParameterTypes();
    }

    Method getMethod() {
        return this.method;
    }

    Object call(Object target, Object[] args2, CallProtocol callProtocol) {
        if (args2 == null) {
            args2 = NULL_ARGS;
        }
        int argsLen = args2.length;
        int paramTypesLen = this.paramTypes.length;
        int paramTypesLenM1 = paramTypesLen - 1;
        boolean varArg = this.method.isVarArgs();
        int fixArgsLen = varArg ? paramTypesLenM1 : paramTypesLen;
        int min2 = Math.min(argsLen, fixArgsLen);
        boolean argsCloned = false;
        for (int i = 0; i < min2; ++i) {
            Object src = args2[i];
            Object dst = SimpleDynamicMethod.marshal(args2[i], this.paramTypes[i], callProtocol);
            if (dst == src) continue;
            if (!argsCloned) {
                args2 = (Object[])args2.clone();
            }
            args2[i] = dst;
        }
        if (varArg) {
            Class varArgType = this.paramTypes[paramTypesLenM1];
            Class<?> componentType = varArgType.getComponentType();
            if (argsLen != paramTypesLen) {
                Object varArgArray;
                Object[] newargs = new Object[paramTypesLen];
                System.arraycopy(args2, 0, newargs, 0, paramTypesLenM1);
                int varArgLen = argsLen - paramTypesLenM1;
                newargs[paramTypesLenM1] = varArgArray = Array.newInstance(componentType, varArgLen);
                for (int i = 0; i < varArgLen; ++i) {
                    Array.set(varArgArray, i, SimpleDynamicMethod.marshal(args2[paramTypesLenM1 + i], componentType, callProtocol));
                }
                args2 = newargs;
            } else {
                Object lastArg = args2[paramTypesLenM1];
                Object varArgArray = callProtocol.representAs(lastArg, varArgType);
                if (varArgArray != null && !varArgType.isInstance(varArgArray)) {
                    varArgArray = Array.newInstance(componentType, 1);
                    Array.set(varArgArray, 0, SimpleDynamicMethod.marshal(lastArg, componentType, callProtocol));
                }
                if (lastArg != varArgArray) {
                    if (!argsCloned) {
                        args2 = (Object[])args2.clone();
                    }
                    args2[paramTypesLenM1] = varArgArray;
                }
            }
        }
        try {
            return this.method.invoke(target, args2);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static Object marshal(Object src, Class targetClass, CallProtocol callProtocol) {
        Object dst = callProtocol.representAs(src, targetClass);
        if (dst == BaseMetaobjectProtocol.Results.noAuthority || dst == BaseMetaobjectProtocol.Results.noRepresentation) {
            String className = src == null ? "null" : src.getClass().getName();
            throw new IllegalArgumentException("Can't represent " + className + " as " + targetClass.getName());
        }
        return dst;
    }
}

