/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.format.syslog;

import java.io.IOException;
import java.io.InputStream;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.factory.OMLinkedListImplFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.format.syslog.InputStreamConsumer;
import org.apache.synapse.format.syslog.ProtocolException;
import org.apache.synapse.format.syslog.SyslogConstants;

public class SyslogMessageBuilder
implements Builder {
    private static final Log log = LogFactory.getLog(SyslogMessageBuilder.class);
    private static final String[] facilityNames = new String[]{"kern", "user", "mail", "daemon", "auth", "syslog", "lpr", "news", "uucp", "cron", "authpriv", "ftp", "reserved0", "reserved1", "reserved2", "reserved3", "local0", "local1", "local2", "local3", "local4", "local5", "local6", "local7"};
    private static final String[] severityNames = new String[]{"emerg", "alert", "crit", "err", "warning", "notice", "info", "debug"};

    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        String facility = null;
        String severity = null;
        String tag = null;
        int pid = -1;
        String content = null;
        InputStreamConsumer in = new InputStreamConsumer(inputStream);
        try {
            int next;
            StringBuilder buffer;
            block17: {
                buffer = new StringBuilder();
                in.consume(60);
                int priority = in.getInteger(3);
                if (priority > 199) {
                    throw new ProtocolException("Invalid priority value (greater than 199)");
                }
                in.consume(62);
                severity = severityNames[priority & 7];
                facility = facilityNames[priority >> 3];
                int savedPosition = in.getPosition();
                try {
                    while (true) {
                        next = in.next();
                        switch (next) {
                            case 91: {
                                in.consume();
                                pid = in.getInteger(6);
                                in.consume(93);
                                in.expect(58);
                            }
                            case 58: {
                                in.consume();
                                in.consume(32);
                                tag = buffer.toString();
                                break block17;
                            }
                            case -1: 
                            case 32: {
                                throw new ProtocolException("Unexpected end of tag");
                            }
                            default: {
                                in.consume();
                                buffer.append((char)next);
                                break;
                            }
                        }
                    }
                }
                catch (ProtocolException ex) {
                    in.setPosition(savedPosition);
                }
            }
            buffer.setLength(0);
            while (true) {
                if ((next = in.next()) == 10) {
                    in.consume();
                    in.consume(-1);
                    continue;
                }
                if (next == -1) {
                    content = buffer.toString();
                    break;
                }
                in.consume();
                buffer.append((char)next);
            }
        }
        catch (ProtocolException ex) {
            log.error((Object)("Protocol error: " + ex.getMessage() + " [pri=" + facility + "." + severity + " tag=" + tag + " pid=" + pid + "]"));
            throw new AxisFault("Protocol error", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new AxisFault("I/O error", (Throwable)ex);
        }
        OMLinkedListImplFactory factory = new OMLinkedListImplFactory();
        OMElement message = factory.createOMElement(SyslogConstants.MESSAGE);
        message.addAttribute(factory.createOMAttribute("facility", null, facility));
        message.addAttribute(factory.createOMAttribute("severity", null, severity));
        if (tag != null) {
            message.addAttribute(factory.createOMAttribute("tag", null, tag));
        }
        if (pid != -1) {
            message.addAttribute(factory.createOMAttribute("pid", null, String.valueOf(pid)));
        }
        message.setText(content);
        return message;
    }
}

