/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.ui.filters;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.commons.codec.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.storm.daemon.StormCommon;
import org.apache.storm.daemon.common.JsonResponseBuilder;
import org.apache.storm.daemon.ui.UIHelpers;
import org.apache.storm.daemon.ui.resources.AuthNimbusOp;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.security.auth.IAuthorizer;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.thrift.TException;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.Utils;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class AuthorizedUserFilter
implements ContainerRequestFilter {
    public static final Logger LOG = LoggerFactory.getLogger(AuthorizedUserFilter.class);
    public static Map<String, Object> conf = Utils.readStormConfig();
    public static IAuthorizer uiImpersonationHandler;
    public static IAuthorizer uiAclHandler;
    @Context
    private ResourceInfo resourceInfo;

    public static Response makeResponse(Exception ex, ContainerRequestContext request, int statusCode) {
        String callback = null;
        if (request.getMediaType() != null && request.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            try {
                String json = IOUtils.toString((InputStream)request.getEntityStream(), (Charset)Charsets.UTF_8);
                InputStream in = IOUtils.toInputStream((String)json);
                request.setEntityStream(in);
                Map requestBody = (Map)JSONValue.parse((String)json);
                if (requestBody.containsKey("callback")) {
                    callback = String.valueOf(requestBody.get("callback"));
                }
            }
            catch (IOException e) {
                LOG.error("Exception while trying to get callback ", (Throwable)e);
            }
        }
        return new JsonResponseBuilder().setData(UIHelpers.exceptionToJson(ex, statusCode)).setCallback(callback).setStatus(statusCode).build();
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        ReqContext reqContext;
        AuthNimbusOp annotation = this.resourceInfo.getResourceMethod().getAnnotation(AuthNimbusOp.class);
        if (annotation == null) {
            return;
        }
        String op = annotation.value();
        if (op == null) {
            return;
        }
        Map topoConf = null;
        if (annotation.needsTopoId()) {
            String topoId = (String)((List)containerRequestContext.getUriInfo().getPathParameters().get((Object)"id")).get(0);
            try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(conf);){
                topoConf = (Map)JSONValue.parse((String)nimbusClient.getClient().getTopologyConf(topoId));
            }
            catch (AuthorizationException ae) {
                LOG.error("Nimbus isn't allowing {} to access the topology conf of {}. {}", new Object[]{ReqContext.context(), topoId, ae.get_msg()});
                containerRequestContext.abortWith(AuthorizedUserFilter.makeResponse((Exception)((Object)ae), containerRequestContext, 403));
                return;
            }
            catch (TException e) {
                LOG.error("Unable to fetch topo conf for {} due to ", (Object)topoId, (Object)e);
                containerRequestContext.abortWith(AuthorizedUserFilter.makeResponse(new IOException("Unable to fetch topo conf for topo id " + topoId, e), containerRequestContext, 500));
                return;
            }
        }
        if ((reqContext = ReqContext.context()).isImpersonating() && uiImpersonationHandler != null) {
            if (!uiImpersonationHandler.permit(reqContext, op, topoConf)) {
                Principal realPrincipal = reqContext.realPrincipal();
                Principal principal = reqContext.principal();
                String user = "unknown";
                if (principal != null) {
                    user = principal.getName();
                }
                String realUser = "unknown";
                if (realPrincipal != null) {
                    realUser = realPrincipal.getName();
                }
                InetAddress remoteAddress = reqContext.remoteAddress();
                containerRequestContext.abortWith(AuthorizedUserFilter.makeResponse((Exception)((Object)new AuthorizationException("user '" + realUser + "' is not authorized to impersonate user '" + user + "' from host '" + remoteAddress.toString() + "'. Pleasesee SECURITY.MD to learn how to configure impersonation ACL.")), containerRequestContext, 401));
                return;
            }
            LOG.warn(" principal {} is trying to impersonate {} but {} has no authorizer configured. This is a potential security hole. Please see SECURITY.MD to learn how to configure an impersonation authorizer.", new Object[]{reqContext.realPrincipal().toString(), reqContext.principal().toString(), conf.get("nimbus.impersonation.authorizer")});
        }
        if (uiAclHandler != null && !uiAclHandler.permit(reqContext, op, topoConf)) {
            Principal principal = reqContext.principal();
            String user = "unknown";
            if (principal != null) {
                user = principal.getName();
            }
            containerRequestContext.abortWith(AuthorizedUserFilter.makeResponse((Exception)((Object)new AuthorizationException("UI request '" + op + "' for '" + user + "' user is not authorized")), containerRequestContext, 403));
            return;
        }
    }

    static {
        try {
            uiImpersonationHandler = StormCommon.mkAuthorizationHandler((String)((String)conf.get("nimbus.impersonation.authorizer")), conf);
            uiAclHandler = StormCommon.mkAuthorizationHandler((String)((String)conf.get("nimbus.authorizer")), conf);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.error("Error initializing AuthorizedUserFilter: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

