/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.ui;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(TestingFilter.class);
    private String userName = "unknown_user";

    public void init(FilterConfig filterConfig) throws ServletException {
        String userName = filterConfig.getInitParameter("USER_NAME");
        if (userName != null) {
            this.userName = userName;
            LOG.info("Will use {} as the user name for all http requests", (Object)userName);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequestWrapper filteredRequest = new HttpServletRequestWrapper((HttpServletRequest)servletRequest){

            public String getRemoteUser() {
                return TestingFilter.this.userName;
            }

            public Principal getUserPrincipal() {
                return () -> TestingFilter.this.userName;
            }
        };
        LOG.debug("Changing user name to {}", (Object)this.userName);
        filterChain.doFilter((ServletRequest)filteredRequest, servletResponse);
    }

    public void destroy() {
    }
}

