/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.logviewer.webapp;

import java.io.File;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.storm.daemon.common.AuthorizationExceptionMapper;
import org.apache.storm.daemon.logviewer.handler.LogviewerLogDownloadHandler;
import org.apache.storm.daemon.logviewer.handler.LogviewerLogPageHandler;
import org.apache.storm.daemon.logviewer.handler.LogviewerLogSearchHandler;
import org.apache.storm.daemon.logviewer.handler.LogviewerProfileHandler;
import org.apache.storm.daemon.logviewer.utils.ResourceAuthorizer;
import org.apache.storm.daemon.logviewer.utils.WorkerLogs;
import org.apache.storm.daemon.logviewer.webapp.LogviewerResource;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.security.auth.IHttpCredentialsPlugin;
import org.apache.storm.security.auth.ServerAuthUtils;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ObjectReader;

@ApplicationPath(value="")
public class LogviewerApplication
extends Application {
    private static Map<String, Object> stormConf;
    private static StormMetricsRegistry metricsRegistry;
    private final Set<Object> singletons = new HashSet<Object>();

    public LogviewerApplication() {
        String logRoot = ConfigUtils.workerArtifactsRoot(stormConf);
        String daemonLogRoot = this.logRootDir(ObjectReader.getString((Object)stormConf.get("logviewer.appender.name")));
        ResourceAuthorizer resourceAuthorizer = new ResourceAuthorizer(stormConf);
        WorkerLogs workerLogs = new WorkerLogs(stormConf, Paths.get(logRoot, new String[0]), metricsRegistry);
        LogviewerLogPageHandler logviewer = new LogviewerLogPageHandler(logRoot, daemonLogRoot, workerLogs, resourceAuthorizer, metricsRegistry);
        LogviewerProfileHandler profileHandler = new LogviewerProfileHandler(logRoot, resourceAuthorizer, metricsRegistry);
        LogviewerLogDownloadHandler logDownloadHandler = new LogviewerLogDownloadHandler(logRoot, daemonLogRoot, workerLogs, resourceAuthorizer, metricsRegistry);
        LogviewerLogSearchHandler logSearchHandler = new LogviewerLogSearchHandler(stormConf, Paths.get(logRoot, new String[0]), Paths.get(daemonLogRoot, new String[0]), resourceAuthorizer, metricsRegistry);
        IHttpCredentialsPlugin httpCredsHandler = ServerAuthUtils.getUiHttpCredentialsPlugin(stormConf);
        this.singletons.add(new LogviewerResource(logviewer, profileHandler, logDownloadHandler, logSearchHandler, httpCredsHandler, metricsRegistry));
        this.singletons.add(new AuthorizationExceptionMapper());
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public static void setup(Map<String, Object> stormConf, StormMetricsRegistry metricRegistry) {
        LogviewerApplication.stormConf = stormConf;
        metricsRegistry = metricRegistry;
    }

    private String logRootDir(String appenderName) {
        Appender appender = ((LoggerContext)LogManager.getContext()).getConfiguration().getAppender(appenderName);
        if (appenderName != null && appender != null && RollingFileAppender.class.isInstance(appender)) {
            return new File(((RollingFileAppender)appender).getFileName()).getParent();
        }
        throw new RuntimeException("Log viewer could not find configured appender, or the appender is not a FileAppender. Please check that the appender name configured in storm and log4j agree.");
    }
}

