/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.drpc.webapp;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.apache.storm.security.auth.IHttpCredentialsPlugin;
import org.apache.storm.security.auth.ReqContext;

@Provider
@PreMatching
public class ReqContextFilter
implements Filter {
    private final IHttpCredentialsPlugin httpCredsHandler;

    public ReqContextFilter(IHttpCredentialsPlugin httpCredsHandler) {
        this.httpCredsHandler = httpCredsHandler;
    }

    public void populateContext(HttpServletRequest request) {
        if (this.httpCredsHandler != null) {
            this.httpCredsHandler.populateContext(ReqContext.context(), request);
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.handle((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request != null) {
            this.populateContext(request);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

