/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.common;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(FileWatcher.class);
    private final WatchService watcher;
    private volatile boolean stopped = false;
    private final Path watchedFile;
    private final Callback callback;
    List<WatchEvent.Kind<Path>> kinds;

    public FileWatcher(Path watchedFile, Callback callback) throws IOException {
        this(watchedFile, callback, Collections.singletonList(StandardWatchEventKinds.ENTRY_MODIFY));
    }

    public FileWatcher(Path watchedFile, Callback callback, List<WatchEvent.Kind<Path>> kinds) throws IOException {
        this.watchedFile = watchedFile;
        this.callback = callback;
        Path parent = watchedFile.getParent();
        this.watcher = parent.getFileSystem().newWatchService();
        this.kinds = kinds;
        parent.register(this.watcher, this.kinds.toArray(new WatchEvent.Kind[0]));
    }

    public void start() {
        Thread t = new Thread((Runnable)this, "FileWatcher-" + this.watchedFile.getFileName());
        t.setDaemon(true);
        LOG.info("Starting FileWatcher on {}", (Object)this.watchedFile);
        t.start();
    }

    public void stop() {
        LOG.info("Stopping FileWatcher on {}", (Object)this.watchedFile);
        this.stopped = true;
    }

    @Override
    public void run() {
        while (!this.stopped) {
            WatchKey watchKey;
            try {
                watchKey = this.watcher.take();
            }
            catch (InterruptedException ex) {
                LOG.warn("FileWatch for {} is interrupted", (Object)this.watchedFile, (Object)ex);
                Thread.currentThread().interrupt();
                return;
            }
            for (WatchEvent<?> event : watchKey.pollEvents()) {
                if (!this.kinds.contains(event.kind()) || !event.context().equals(this.watchedFile.getFileName())) continue;
                try {
                    LOG.info("Event {} on {}; invoking callback", event.kind(), (Object)this.watchedFile);
                    this.callback.run();
                }
                catch (Exception ex) {
                    LOG.error("Error invoking FileWatcher callback for {}", (Object)this.watchedFile, (Object)ex);
                }
            }
            watchKey.reset();
        }
    }

    public static interface Callback {
        public void run() throws Exception;
    }
}

