/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class RpcThrottlingException
extends HBaseIOException {
    private static final String[] MSG_TYPE = new String[]{"number of requests exceeded", "request size limit exceeded", "number of read requests exceeded", "number of write requests exceeded", "write size limit exceeded", "read size limit exceeded"};
    private static final String MSG_WAIT = " - wait ";
    private long waitInterval;
    private Type type;

    public RpcThrottlingException(String msg) {
        super(msg);
        for (int i = 0; i < MSG_TYPE.length; ++i) {
            int index = msg.indexOf(MSG_TYPE[i]);
            if (index < 0) continue;
            String waitTimeStr = msg.substring(index + MSG_TYPE[i].length() + MSG_WAIT.length());
            this.type = Type.values()[i];
            this.waitInterval = RpcThrottlingException.timeFromString(waitTimeStr);
            break;
        }
    }

    public RpcThrottlingException(Type type, long waitInterval, String msg) {
        super(msg);
        this.waitInterval = waitInterval;
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public long getWaitInterval() {
        return this.waitInterval;
    }

    public static void throwNumRequestsExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.NumRequestsExceeded, waitInterval);
    }

    public static void throwRequestSizeExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.RequestSizeExceeded, waitInterval);
    }

    public static void throwNumReadRequestsExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.NumReadRequestsExceeded, waitInterval);
    }

    public static void throwNumWriteRequestsExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.NumWriteRequestsExceeded, waitInterval);
    }

    public static void throwWriteSizeExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.WriteSizeExceeded, waitInterval);
    }

    public static void throwReadSizeExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.ReadSizeExceeded, waitInterval);
    }

    private static void throwThrottlingException(Type type, long waitInterval) throws RpcThrottlingException {
        String msg = MSG_TYPE[type.ordinal()] + MSG_WAIT + StringUtils.formatTime((long)waitInterval);
        throw new RpcThrottlingException(type, waitInterval, msg);
    }

    private static long timeFromString(String timeDiff) {
        Pattern[] patterns = new Pattern[]{Pattern.compile("^(\\d+\\.\\d\\d)sec"), Pattern.compile("^(\\d+)mins, (\\d+\\.\\d\\d)sec"), Pattern.compile("^(\\d+)hrs, (\\d+)mins, (\\d+\\.\\d\\d)sec")};
        for (int i = 0; i < patterns.length; ++i) {
            Matcher m = patterns[i].matcher(timeDiff);
            if (!m.find()) continue;
            long time = Math.round(Float.parseFloat(m.group(1 + i)) * 1000.0f);
            if (i > 0) {
                time += Long.parseLong(m.group(i)) * 60000L;
            }
            if (i > 1) {
                time += Long.parseLong(m.group(i - 1)) * 3600000L;
            }
            return time;
        }
        return -1L;
    }

    @InterfaceAudience.Public
    public static enum Type {
        NumRequestsExceeded,
        RequestSizeExceeded,
        NumReadRequestsExceeded,
        NumWriteRequestsExceeded,
        WriteSizeExceeded,
        ReadSizeExceeded;

    }
}

