/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MasterFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(MasterFileSystem.class);
    public static final String HBASE_DIR_PERMS = "hbase.rootdir.perms";
    public static final String HBASE_WAL_DIR_PERMS = "hbase.wal.dir.perms";
    private final Configuration conf;
    private ClusterId clusterId;
    private final FileSystem fs;
    private final FileSystem walFs;
    private final Path rootdir;
    private final Path tempdir;
    private final Path walRootDir;
    private final FsPermission secureRootSubDirPerms;
    private final FsPermission secureRootFilePerms = new FsPermission("600");
    private final FsPermission HiddenDirPerms = FsPermission.valueOf((String)"-rwx--x--x");
    private boolean isSecurityEnabled;

    public MasterFileSystem(Configuration conf) throws IOException {
        this.conf = conf;
        this.rootdir = FSUtils.getRootDir((Configuration)conf);
        this.tempdir = new Path(this.rootdir, ".tmp");
        this.fs = this.rootdir.getFileSystem(conf);
        this.walRootDir = FSUtils.getWALRootDir((Configuration)conf);
        this.walFs = FSUtils.getWALFileSystem((Configuration)conf);
        FSUtils.setFsDefault((Configuration)conf, (Path)new Path(this.walFs.getUri()));
        this.walFs.setConf(conf);
        FSUtils.setFsDefault((Configuration)conf, (Path)new Path(this.fs.getUri()));
        this.fs.setConf(conf);
        this.secureRootSubDirPerms = new FsPermission(conf.get(HBASE_DIR_PERMS, "700"));
        this.isSecurityEnabled = "kerberos".equalsIgnoreCase(conf.get("hbase.security.authentication"));
        this.createInitialFileSystemLayout();
        HFileSystem.addLocationsOrderInterceptor(conf);
    }

    private void createInitialFileSystemLayout() throws IOException {
        FsPermission currentRootPerms;
        String[] protectedSubDirs = new String[]{"data", "archive", ".hbck", "mobdir"};
        String[] protectedSubLogDirs = new String[]{"WALs", "oldWALs", "corrupt", "MasterProcWALs"};
        this.checkRootDir(this.rootdir, this.conf, this.fs);
        this.checkTempDir(this.tempdir, this.conf, this.fs);
        for (String subDir : protectedSubDirs) {
            this.checkSubDir(new Path(this.rootdir, subDir), HBASE_DIR_PERMS);
        }
        String perms = !this.walRootDir.equals((Object)this.rootdir) ? HBASE_WAL_DIR_PERMS : HBASE_DIR_PERMS;
        for (String subDir : protectedSubLogDirs) {
            this.checkSubDir(new Path(this.walRootDir, subDir), perms);
        }
        this.checkStagingDir();
        if (this.isSecurityEnabled) {
            this.fs.setPermission(new Path(this.rootdir, "hbase.version"), this.secureRootFilePerms);
            this.fs.setPermission(new Path(this.rootdir, "hbase.id"), this.secureRootFilePerms);
        }
        if (!((currentRootPerms = this.fs.getFileStatus(this.rootdir).getPermission()).getUserAction().implies(FsAction.EXECUTE) && currentRootPerms.getGroupAction().implies(FsAction.EXECUTE) && currentRootPerms.getOtherAction().implies(FsAction.EXECUTE))) {
            LOG.warn("rootdir permissions do not contain 'excute' for user, group or other. Automatically adding 'excute' permission for all");
            this.fs.setPermission(this.rootdir, new FsPermission(currentRootPerms.getUserAction().or(FsAction.EXECUTE), currentRootPerms.getGroupAction().or(FsAction.EXECUTE), currentRootPerms.getOtherAction().or(FsAction.EXECUTE)));
        }
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    protected FileSystem getWALFileSystem() {
        return this.walFs;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public Path getRootDir() {
        return this.rootdir;
    }

    public Path getWALRootDir() {
        return this.walRootDir;
    }

    public Path getRegionDir(RegionInfo region) {
        return FSUtils.getRegionDir(FSUtils.getTableDir((Path)this.getRootDir(), (TableName)region.getTable()), region);
    }

    public Path getTempDir() {
        return this.tempdir;
    }

    public ClusterId getClusterId() {
        return this.clusterId;
    }

    private Path checkRootDir(Path rd, Configuration c, FileSystem fs) throws IOException {
        FSUtils.waitOnSafeMode(c, c.getInt("hbase.server.thread.wakefrequency", 10000));
        try {
            if (!fs.exists(rd)) {
                fs.mkdirs(rd);
                FSUtils.setVersion(fs, rd, c.getInt("hbase.server.thread.wakefrequency", 10000), c.getInt("hbase.server.versionfile.writeattempts", 3));
            } else {
                if (!fs.isDirectory(rd)) {
                    throw new IllegalArgumentException(rd.toString() + " is not a directory");
                }
                FSUtils.checkVersion(fs, rd, true, c.getInt("hbase.server.thread.wakefrequency", 10000), c.getInt("hbase.server.versionfile.writeattempts", 3));
            }
        }
        catch (DeserializationException de) {
            LOG.error(HBaseMarkers.FATAL, "Please fix invalid configuration for hbase.rootdir", (Throwable)de);
            IOException ioe = new IOException();
            ioe.initCause(de);
            throw ioe;
        }
        catch (IllegalArgumentException iae) {
            LOG.error(HBaseMarkers.FATAL, "Please fix invalid configuration for hbase.rootdir " + rd.toString(), (Throwable)iae);
            throw iae;
        }
        if (!FSUtils.checkClusterIdExists(fs, rd, c.getInt("hbase.server.thread.wakefrequency", 10000))) {
            FSUtils.setClusterId(fs, rd, new ClusterId(), c.getInt("hbase.server.thread.wakefrequency", 10000));
        }
        this.clusterId = FSUtils.getClusterId(fs, rd);
        if (!FSUtils.metaRegionExists(fs, rd)) {
            MasterFileSystem.bootstrap(rd, c);
        }
        FSTableDescriptors fsd = new FSTableDescriptors(c, fs, rd);
        fsd.createTableDescriptor(fsd.get(TableName.META_TABLE_NAME));
        return rd;
    }

    private void checkTempDir(Path tmpdir, Configuration c, FileSystem fs) throws IOException {
        if (fs.exists(tmpdir)) {
            for (Path tabledir : FSUtils.getTableDirs(fs, tmpdir)) {
                for (Path regiondir : FSUtils.getRegionDirs(fs, tabledir)) {
                    HFileArchiver.archiveRegion(fs, this.rootdir, tabledir, regiondir);
                }
            }
            if (!fs.delete(tmpdir, true)) {
                throw new IOException("Unable to clean the temp directory: " + tmpdir);
            }
        }
        if (this.isSecurityEnabled ? !fs.mkdirs(tmpdir, this.secureRootSubDirPerms) : !fs.mkdirs(tmpdir)) {
            throw new IOException("HBase temp directory '" + tmpdir + "' creation failure.");
        }
    }

    private void checkSubDir(Path p, String dirPermsConfName) throws IOException {
        FileSystem fs = p.getFileSystem(this.conf);
        FsPermission dirPerms = new FsPermission(this.conf.get(dirPermsConfName, "700"));
        if (!fs.exists(p)) {
            if (this.isSecurityEnabled ? !fs.mkdirs(p, this.secureRootSubDirPerms) : !fs.mkdirs(p)) {
                throw new IOException("HBase directory '" + p + "' creation failure.");
            }
        } else if (this.isSecurityEnabled && !dirPerms.equals((Object)fs.getFileStatus(p).getPermission())) {
            LOG.warn("Found HBase directory permissions NOT matching expected permissions for " + p.toString() + " permissions=" + fs.getFileStatus(p).getPermission() + ", expecting " + dirPerms + ". Automatically setting the permissions. You can change the permissions by setting \"" + dirPermsConfName + "\" in hbase-site.xml and restarting the master");
            fs.setPermission(p, dirPerms);
        }
    }

    private void checkStagingDir() throws IOException {
        Path p = new Path(this.rootdir, "staging");
        try {
            if (!this.fs.exists(p)) {
                if (!this.fs.mkdirs(p, this.HiddenDirPerms)) {
                    throw new IOException("Failed to create staging directory " + p.toString());
                }
            } else {
                this.fs.setPermission(p, this.HiddenDirPerms);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to create or set permission on staging directory " + p.toString());
            throw new IOException("Failed to create or set permission on staging directory " + p.toString(), e);
        }
    }

    private static void bootstrap(Path rd, Configuration c) throws IOException {
        LOG.info("BOOTSTRAP: creating hbase:meta region");
        try {
            TableDescriptor metaDescriptor = new FSTableDescriptors(c).get(TableName.META_TABLE_NAME);
            HRegion meta = HRegion.createHRegion(RegionInfoBuilder.FIRST_META_REGIONINFO, rd, c, MasterFileSystem.setInfoFamilyCachingForMeta(metaDescriptor, false), null);
            meta.close();
        }
        catch (IOException e) {
            e = e instanceof RemoteException ? ((RemoteException)((Object)e)).unwrapRemoteException() : e;
            LOG.error("bootstrap", (Throwable)e);
            throw e;
        }
    }

    public static TableDescriptor setInfoFamilyCachingForMeta(TableDescriptor metaDescriptor, boolean b) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)metaDescriptor);
        for (ColumnFamilyDescriptor hcd : metaDescriptor.getColumnFamilies()) {
            if (!Bytes.equals((byte[])hcd.getName(), (byte[])HConstants.CATALOG_FAMILY)) continue;
            builder.modifyColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)hcd).setBlockCacheEnabled(b).setInMemory(b).build());
        }
        return builder.build();
    }

    public void deleteFamilyFromFS(RegionInfo region, byte[] familyName) throws IOException {
        this.deleteFamilyFromFS(this.rootdir, region, familyName);
    }

    public void deleteFamilyFromFS(Path rootDir, RegionInfo region, byte[] familyName) throws IOException {
        Path tableDir = FSUtils.getTableDir((Path)rootDir, (TableName)region.getTable());
        HFileArchiver.archiveFamily(this.fs, this.conf, region, tableDir, familyName);
        Path familyDir = new Path(tableDir, new Path(region.getEncodedName(), Bytes.toString((byte[])familyName)));
        if (!this.fs.delete(familyDir, true) && this.fs.exists(familyDir)) {
            throw new IOException("Could not delete family " + Bytes.toString((byte[])familyName) + " from FileSystem for region " + region.getRegionNameAsString() + "(" + region.getEncodedName() + ")");
        }
    }

    public void stop() {
    }

    public void logFileSystemState(Logger log) throws IOException {
        FSUtils.logFileSystemState((FileSystem)this.fs, (Path)this.rootdir, (Logger)log);
    }
}

