/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import org.apache.storm.multilang.ShellMsg;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.utils.ShellLogHandler;
import org.apache.storm.utils.ShellProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultShellLogHandler
implements ShellLogHandler {
    private Logger log;
    private ShellProcess process;

    private Logger getLogger(Class<?> ownerCls) {
        return LoggerFactory.getLogger(ownerCls == null ? DefaultShellLogHandler.class : ownerCls);
    }

    @Override
    public void setUpContext(Class<?> ownerCls, ShellProcess process, TopologyContext context) {
        this.log = this.getLogger(ownerCls);
        this.process = process;
    }

    @Override
    public void log(ShellMsg shellMsg) {
        if (shellMsg == null) {
            throw new IllegalArgumentException("shellMsg is required");
        }
        String msg = shellMsg.getMsg();
        if (this.log == null) {
            this.log = this.getLogger(null);
        }
        msg = this.process == null ? "ShellLog " + msg : "ShellLog " + this.process.getProcessInfoString() + " " + msg;
        ShellMsg.ShellLogLevel logLevel = shellMsg.getLogLevel();
        switch (logLevel) {
            case TRACE: {
                this.log.trace(msg);
                break;
            }
            case DEBUG: {
                this.log.debug(msg);
                break;
            }
            case INFO: {
                this.log.info(msg);
                break;
            }
            case WARN: {
                this.log.warn(msg);
                break;
            }
            case ERROR: {
                this.log.error(msg);
                break;
            }
            default: {
                this.log.info(msg);
            }
        }
    }
}

