/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.generated.ComponentCommon;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.Grouping;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.shade.org.json.simple.JSONAware;
import org.apache.storm.shade.org.json.simple.JSONValue;
import org.apache.storm.shade.org.json.simple.parser.ParseException;
import org.apache.storm.tuple.Fields;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ThriftTopologyUtils;

public class GeneralTopologyContext
implements JSONAware {
    protected Map<String, Object> topoConf;
    protected boolean doSanityCheck;
    private StormTopology topology;
    private Map<Integer, String> taskToComponent;
    private Map<String, List<Integer>> componentToTasks;
    private Map<String, Map<String, Fields>> componentToStreamToFields;
    private String stormId;

    public GeneralTopologyContext(StormTopology topology, Map<String, Object> topoConf, Map<Integer, String> taskToComponent, Map<String, List<Integer>> componentToSortedTasks, Map<String, Map<String, Fields>> componentToStreamToFields, String stormId) {
        this.topology = topology;
        this.topoConf = topoConf;
        this.taskToComponent = taskToComponent;
        this.stormId = stormId;
        this.componentToTasks = componentToSortedTasks;
        this.componentToStreamToFields = componentToStreamToFields;
        this.doSanityCheck = ConfigUtils.isLocalMode(this.topoConf);
    }

    public String getStormId() {
        return this.stormId;
    }

    public StormTopology getRawTopology() {
        return this.topology;
    }

    public String getComponentId(int taskId) {
        if ((long)taskId == -1L) {
            return "__system";
        }
        return this.taskToComponent.get(taskId);
    }

    public Set<String> getComponentStreams(String componentId) {
        return this.getComponentCommon(componentId).get_streams().keySet();
    }

    public List<Integer> getComponentTasks(String componentId) {
        List<Integer> ret = this.componentToTasks.get(componentId);
        if (ret == null) {
            return new ArrayList<Integer>();
        }
        return new ArrayList<Integer>(ret);
    }

    public Fields getComponentOutputFields(String componentId, String streamId) {
        Fields ret = this.componentToStreamToFields.get(componentId).get(streamId);
        if (ret == null) {
            throw new IllegalArgumentException("No output fields defined for component:stream " + componentId + ":" + streamId);
        }
        return ret;
    }

    public Fields getComponentOutputFields(GlobalStreamId id) {
        return this.getComponentOutputFields(id.get_componentId(), id.get_streamId());
    }

    public Map<GlobalStreamId, Grouping> getSources(String componentId) {
        return this.getComponentCommon(componentId).get_inputs();
    }

    public Map<String, Map<String, Grouping>> getTargets(String componentId) {
        HashMap<String, Map<String, Grouping>> ret = new HashMap<String, Map<String, Grouping>>();
        for (String otherComponentId : this.getComponentIds()) {
            Map<GlobalStreamId, Grouping> inputs = this.getComponentCommon(otherComponentId).get_inputs();
            for (Map.Entry<GlobalStreamId, Grouping> entry : inputs.entrySet()) {
                GlobalStreamId id = entry.getKey();
                if (!id.get_componentId().equals(componentId)) continue;
                HashMap<String, Grouping> curr = (HashMap<String, Grouping>)ret.get(id.get_streamId());
                if (curr == null) {
                    curr = new HashMap<String, Grouping>();
                }
                curr.put(otherComponentId, entry.getValue());
                ret.put(id.get_streamId(), curr);
            }
        }
        return ret;
    }

    public String toJSONString() {
        HashMap<String, Map<Integer, String>> obj = new HashMap<String, Map<Integer, String>>();
        obj.put("task->component", this.taskToComponent);
        return JSONValue.toJSONString(obj);
    }

    public Map<Integer, String> getTaskToComponent() {
        return this.taskToComponent;
    }

    public Set<String> getComponentIds() {
        return ThriftTopologyUtils.getComponentIds(this.getRawTopology());
    }

    public ComponentCommon getComponentCommon(String componentId) {
        return ThriftTopologyUtils.getComponentCommon(this.getRawTopology(), componentId);
    }

    public int maxTopologyMessageTimeout() {
        Integer max = ObjectReader.getInt(this.topoConf.get("topology.message.timeout.secs"));
        for (String spout : this.getRawTopology().get_spouts().keySet()) {
            ComponentCommon common = this.getComponentCommon(spout);
            String jsonConf = common.get_json_conf();
            if (jsonConf == null) continue;
            try {
                Map conf = (Map)JSONValue.parseWithException((String)jsonConf);
                Object comp = conf.get("topology.message.timeout.secs");
                max = Math.max(ObjectReader.getInt(comp, max), max);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return max;
    }

    public Map<String, Object> getConf() {
        return this.topoConf;
    }

    public boolean doSanityCheck() {
        return this.doSanityCheck;
    }
}

