/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams.processors;

import java.util.Set;
import org.apache.storm.shade.com.google.common.collect.Multimap;
import org.apache.storm.streams.ProcessorNode;
import org.apache.storm.streams.processors.Processor;
import org.apache.storm.streams.processors.ProcessorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardingProcessorContext
implements ProcessorContext {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardingProcessorContext.class);
    private final ProcessorNode processorNode;
    private final Multimap<String, ProcessorNode> streamToChildren;
    private final Set<String> streams;

    public ForwardingProcessorContext(ProcessorNode processorNode, Multimap<String, ProcessorNode> streamToChildren) {
        this.processorNode = processorNode;
        this.streamToChildren = streamToChildren;
        this.streams = streamToChildren.keySet();
    }

    @Override
    public <T> void forward(T input) {
        if ("__punctuation".equals(input)) {
            this.finishAllStreams();
        } else {
            this.executeAllStreams(input);
        }
    }

    @Override
    public <T> void forward(T input, String stream) {
        if ("__punctuation".equals(input)) {
            this.finish(stream);
        } else {
            this.execute(input, stream);
        }
    }

    @Override
    public boolean isWindowed() {
        return this.processorNode.isWindowed();
    }

    @Override
    public Set<String> getWindowedParentStreams() {
        return this.processorNode.getWindowedParentStreams();
    }

    private void finishAllStreams() {
        for (String stream : this.streams) {
            this.finish(stream);
        }
    }

    private <T> void finish(String stream) {
        for (ProcessorNode node : this.streamToChildren.get((Object)stream)) {
            LOG.debug("Punctuating processor: {}", (Object)node);
            Processor<?> processor = node.getProcessor();
            processor.punctuate(stream);
        }
    }

    private <T> void executeAllStreams(T input) {
        for (String stream : this.streams) {
            this.execute(input, stream);
        }
    }

    private <T> void execute(T input, String stream) {
        for (ProcessorNode node : this.streamToChildren.get((Object)stream)) {
            LOG.debug("Forward input: {} to processor node: {}", input, (Object)node);
            Processor<?> processor = node.getProcessor();
            processor.execute(input, stream);
        }
    }
}

