/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.kerberos;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.xml.bind.DatatypeConverter;
import org.apache.storm.metric.api.IMetricsRegistrant;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.IAutoCredentials;
import org.apache.storm.security.auth.ICredentialsRenewer;
import org.apache.storm.security.auth.kerberos.ClientCallbackHandler;
import org.apache.storm.task.TopologyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTGT
implements IAutoCredentials,
ICredentialsRenewer,
IMetricsRegistrant {
    protected static final AtomicReference<KerberosTicket> kerbTicket = new AtomicReference();
    private static final Logger LOG = LoggerFactory.getLogger(AutoTGT.class);
    private static final float TICKET_RENEW_WINDOW = 0.8f;
    private Map<String, Object> conf;
    private Map<String, String> credentials;

    private static KerberosTicket getTGT(Subject subject) {
        Set<KerberosTicket> tickets = subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            KerberosPrincipal server = ticket.getServer();
            if (!server.getName().equals("krbtgt/" + server.getRealm() + "@" + server.getRealm())) continue;
            return ticket;
        }
        return null;
    }

    public static KerberosTicket getTGT(Map<String, String> credentials) {
        KerberosTicket ret = null;
        if (credentials != null && credentials.containsKey("TGT") && credentials.get("TGT") != null) {
            ret = ClientAuthUtils.deserializeKerberosTicket(DatatypeConverter.parseBase64Binary((String)credentials.get("TGT")));
        }
        return ret;
    }

    public static void saveTGT(KerberosTicket tgt, Map<String, String> credentials) {
        try {
            byte[] bytes = ClientAuthUtils.serializeKerberosTicket(tgt);
            credentials.put("TGT", DatatypeConverter.printBase64Binary((byte[])bytes));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCredentials(Subject subject, KerberosTicket tgt) {
        Set<Object> creds;
        Set<Object> set = creds = subject.getPrivateCredentials();
        synchronized (set) {
            Iterator<Object> iterator = creds.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!(o instanceof KerberosTicket)) continue;
                KerberosTicket t = (KerberosTicket)o;
                iterator.remove();
                try {
                    t.destroy();
                }
                catch (DestroyFailedException e) {
                    LOG.warn("Failed to destory ticket ", (Throwable)e);
                }
            }
            if (tgt != null) {
                creds.add(tgt);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        AutoTGT at = new AutoTGT();
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("java.security.auth.login.config", args[0]);
        at.prepare(conf);
        HashMap<String, String> creds = new HashMap<String, String>();
        at.populateCredentials(creds);
        Subject s = new Subject();
        at.populateSubject(s, creds);
        LOG.info("Got a Subject " + s);
    }

    @Override
    public void prepare(Map<String, Object> conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateCredentials(Map<String, String> credentials) {
        this.credentials = credentials;
        try {
            Configuration loginConf = ClientAuthUtils.getConfiguration(this.conf);
            ClientCallbackHandler clientCallbackHandler = new ClientCallbackHandler(this.conf);
            LoginContext lc = new LoginContext("StormClient", null, clientCallbackHandler, loginConf);
            try {
                lc.login();
                Subject subject = lc.getSubject();
                KerberosTicket tgt = AutoTGT.getTGT(subject);
                if (tgt == null) {
                    throw new RuntimeException("Fail to verify user principal with section \"StormClient\" in login configuration file " + loginConf);
                }
                if (!tgt.isForwardable()) {
                    throw new RuntimeException("The TGT found is not forwardable. Please use -f option with 'kinit'.");
                }
                if (!tgt.isRenewable()) {
                    throw new RuntimeException("The TGT found is not renewable. Please use -r option with 'kinit'.");
                }
                if (tgt.getClientAddresses() != null) {
                    throw new RuntimeException("The TGT found is not address-less. Please use -A option with 'kinit'.");
                }
                LOG.info("Pushing TGT for " + tgt.getClient() + " to topology.");
                AutoTGT.saveTGT(tgt, credentials);
            }
            finally {
                lc.logout();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateSubject(Subject subject, Map<String, String> credentials) {
        this.credentials = credentials;
        this.populateSubjectWithTGT(subject, credentials);
    }

    @Override
    public void populateSubject(Subject subject, Map<String, String> credentials) {
        this.credentials = credentials;
        this.populateSubjectWithTGT(subject, credentials);
        this.loginHadoopUser(subject);
    }

    private void populateSubjectWithTGT(Subject subject, Map<String, String> credentials) {
        LOG.info("Populating TGT from credentials");
        KerberosTicket tgt = AutoTGT.getTGT(credentials);
        if (tgt != null) {
            AutoTGT.clearCredentials(subject, tgt);
            subject.getPrincipals().add(tgt.getClient());
            kerbTicket.set(tgt);
        } else {
            LOG.info("No TGT found in credentials");
        }
    }

    private void loginHadoopUser(Subject subject) {
        Class<?> ugi;
        try {
            ugi = Class.forName("org.apache.hadoop.security.UserGroupInformation");
        }
        catch (ClassNotFoundException e) {
            LOG.info("Hadoop was not found on the class path");
            return;
        }
        try {
            Method isSecEnabled = ugi.getMethod("isSecurityEnabled", new Class[0]);
            if (!((Boolean)isSecEnabled.invoke(null, new Object[0])).booleanValue()) {
                LOG.warn("Hadoop is on the classpath but not configured for security, if you want security you need to be sure that hadoop.security.authentication=kerberos in core-site.xml in your jar");
                return;
            }
            Class<?> confClass = Class.forName("org.apache.hadoop.conf.Configuration");
            Constructor<?> confCons = confClass.getConstructor(new Class[0]);
            Object conf = confCons.newInstance(new Object[0]);
            Class<?> hknClass = Class.forName("org.apache.hadoop.security.HadoopKerberosName");
            Method hknSetConf = hknClass.getMethod("setConfiguration", confClass);
            hknSetConf.invoke(null, conf);
            Class<?> authMethodClass = Class.forName("org.apache.hadoop.security.UserGroupInformation$AuthenticationMethod");
            Object kerbAuthMethod = null;
            for (Object authMethod : authMethodClass.getEnumConstants()) {
                if (!"KERBEROS".equals(authMethod.toString())) continue;
                kerbAuthMethod = authMethod;
                break;
            }
            Class<?> userClass = Class.forName("org.apache.hadoop.security.User");
            Constructor<?> userCons = userClass.getConstructor(String.class, authMethodClass, LoginContext.class);
            userCons.setAccessible(true);
            String name = AutoTGT.getTGT(subject).getClient().toString();
            Object user = userCons.newInstance(name, kerbAuthMethod, null);
            subject.getPrincipals().add((Principal)user);
        }
        catch (Exception e) {
            LOG.error("Something went wrong while trying to initialize Hadoop through reflection. This version of hadoop may not be compatible.", (Throwable)e);
        }
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long end = tgt.getEndTime().getTime();
        return start + (long)((float)(end - start) * 0.8f);
    }

    @Override
    public void renew(Map<String, String> credentials, Map<String, Object> topologyConf, String topologyOwnerPrincipal) {
        this.credentials = credentials;
        KerberosTicket tgt = AutoTGT.getTGT(credentials);
        if (tgt != null) {
            long refreshTime = this.getRefreshTime(tgt);
            long now = System.currentTimeMillis();
            if (now >= refreshTime) {
                try {
                    LOG.info("Renewing TGT for " + tgt.getClient());
                    tgt.refresh();
                    AutoTGT.saveTGT(tgt, credentials);
                }
                catch (RefreshFailedException e) {
                    LOG.warn("Failed to refresh TGT", (Throwable)e);
                }
            }
        }
    }

    private Long getMsecsUntilExpiration() {
        KerberosTicket tgt = AutoTGT.getTGT(this.credentials);
        if (tgt == null) {
            return null;
        }
        long end = tgt.getEndTime().getTime();
        return end - System.currentTimeMillis();
    }

    @Override
    public void registerMetrics(TopologyContext topoContext, Map<String, Object> topoConf) {
        int bucketSize = ((Number)topoConf.get("topology.builtin.metrics.bucket.size.secs")).intValue();
        topoContext.registerMetric("TGT-TimeToExpiryMsecs", () -> this.getMsecsUntilExpiration(), bucketSize);
    }
}

