/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.policy;

import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import org.apache.storm.policy.IWaitStrategy;
import org.apache.storm.utils.ObjectReader;

public class WaitStrategyPark
implements IWaitStrategy {
    private long parkTimeNanoSec;

    public WaitStrategyPark() {
    }

    public WaitStrategyPark(long microsec) {
        this.parkTimeNanoSec = microsec * 1000L;
    }

    @Override
    public void prepare(Map<String, Object> conf, IWaitStrategy.WaitSituation waitSituation) {
        if (waitSituation == IWaitStrategy.WaitSituation.SPOUT_WAIT) {
            this.parkTimeNanoSec = 1000L * ObjectReader.getLong(conf.get("topology.spout.wait.park.microsec"));
        } else if (waitSituation == IWaitStrategy.WaitSituation.BOLT_WAIT) {
            this.parkTimeNanoSec = 1000L * ObjectReader.getLong(conf.get("topology.bolt.wait.park.microsec"));
        } else if (waitSituation == IWaitStrategy.WaitSituation.BACK_PRESSURE_WAIT) {
            this.parkTimeNanoSec = 1000L * ObjectReader.getLong(conf.get("topology.backpressure.wait.park.microsec"));
        } else {
            throw new IllegalArgumentException("Unknown wait situation : " + (Object)((Object)waitSituation));
        }
    }

    @Override
    public int idle(int idleCounter) throws InterruptedException {
        if (this.parkTimeNanoSec == 0L) {
            return 1;
        }
        LockSupport.parkNanos(this.parkTimeNanoSec);
        return idleCounter + 1;
    }
}

