/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.pacemaker;

import java.net.ConnectException;
import org.apache.storm.generated.HBMessage;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.pacemaker.PacemakerClient;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacemakerClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(PacemakerClientHandler.class);
    private final PacemakerClient client;

    public PacemakerClientHandler(PacemakerClient client) {
        this.client = client;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        LOG.info("Connection established from {} to {}", (Object)channel.localAddress(), (Object)channel.remoteAddress());
        this.client.channelReady(channel);
    }

    public void channelRead(ChannelHandlerContext ctx, Object message) {
        LOG.debug("Got Message: {}", (Object)message.toString());
        if (message instanceof ControlMessage) {
            LOG.debug("Got control message: {}", (Object)message.toString());
            return;
        }
        if (message instanceof HBMessage) {
            this.client.gotMessage((HBMessage)message);
        } else {
            LOG.warn("Got unexpected message: {} from server.", message);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof ConnectException) {
            LOG.warn("Connection to pacemaker failed. Trying to reconnect {}", (Object)cause.getMessage());
        } else {
            LOG.error("Exception occurred in Pacemaker: " + cause);
        }
        this.client.reconnect();
    }
}

