/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2.reporters;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.daemon.metrics.ClientMetricsUtils;
import org.apache.storm.metrics2.filters.StormMetricsFilter;
import org.apache.storm.metrics2.reporters.ScheduledStormReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleStormReporter
extends ScheduledStormReporter {
    private static final Logger LOG = LoggerFactory.getLogger(ConsoleStormReporter.class);

    public void prepare(MetricRegistry registry, Map stormConf, Map reporterConf) {
        StormMetricsFilter filter;
        TimeUnit durationUnit;
        TimeUnit rateUnit;
        LOG.debug("Preparing ConsoleReporter");
        ConsoleReporter.Builder builder = ConsoleReporter.forRegistry((MetricRegistry)registry);
        builder.outputTo(System.out);
        Locale locale = ClientMetricsUtils.getMetricsReporterLocale(stormConf);
        if (locale != null) {
            builder.formattedFor(locale);
        }
        if ((rateUnit = ClientMetricsUtils.getMetricsRateUnit(stormConf)) != null) {
            builder.convertRatesTo(rateUnit);
        }
        if ((durationUnit = ClientMetricsUtils.getMetricsDurationUnit(stormConf)) != null) {
            builder.convertDurationsTo(durationUnit);
        }
        if ((filter = ConsoleStormReporter.getMetricsFilter(reporterConf)) != null) {
            builder.filter((MetricFilter)filter);
        }
        this.reportingPeriod = ConsoleStormReporter.getReportPeriod(reporterConf);
        this.reportingPeriodUnit = ConsoleStormReporter.getReportPeriodUnit(reporterConf);
        this.reporter = builder.build();
    }
}

