/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.storm.cluster.DaemonType;
import org.apache.storm.metrics2.JcMetrics;
import org.apache.storm.metrics2.SimpleGauge;
import org.apache.storm.metrics2.reporters.StormReporter;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormMetricRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(StormMetricRegistry.class);
    private static final String WORKER_METRIC_PREFIX = "storm.worker.";
    private static final String TOPOLOGY_METRIC_PREFIX = "storm.topology.";
    private final MetricRegistry registry = new MetricRegistry();
    private final List<StormReporter> reporters = new ArrayList<StormReporter>();
    private final ConcurrentMap<Integer, Map<String, Gauge>> taskIdGauges = new ConcurrentHashMap<Integer, Map<String, Gauge>>();
    private final ConcurrentMap<Integer, Map<String, Meter>> taskIdMeters = new ConcurrentHashMap<Integer, Map<String, Meter>>();
    private final ConcurrentMap<Integer, Map<String, Counter>> taskIdCounters = new ConcurrentHashMap<Integer, Map<String, Counter>>();
    private final ConcurrentMap<Integer, Map<String, Timer>> taskIdTimers = new ConcurrentHashMap<Integer, Map<String, Timer>>();
    private final ConcurrentMap<Integer, Map<String, Histogram>> taskIdHistograms = new ConcurrentHashMap<Integer, Map<String, Histogram>>();
    private String hostName = null;

    public <T> SimpleGauge<T> gauge(T initialValue, String name, String topologyId, String componentId, Integer taskId, Integer port) {
        MetricNames metricNames = this.workerMetricName(name, topologyId, componentId, taskId, port);
        Gauge gauge = this.registry.gauge(metricNames.getLongName(), () -> new SimpleGauge<Object>(initialValue));
        StormMetricRegistry.saveMetricTaskIdMapping(taskId, metricNames, gauge, this.taskIdGauges);
        return (SimpleGauge)gauge;
    }

    public <T> Gauge<T> gauge(String name, Gauge<T> gauge, TopologyContext context) {
        MetricNames metricNames = this.topologyMetricName(name, context);
        gauge = (Gauge)this.registry.register(metricNames.getLongName(), gauge);
        StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, gauge, this.taskIdGauges);
        return gauge;
    }

    public JcMetrics jcMetrics(String name, String topologyId, String componentId, Integer taskId, Integer port) {
        SimpleGauge<Long> capacityGauge = this.gauge(0L, name + "-capacity", topologyId, componentId, taskId, port);
        SimpleGauge<Long> populationGauge = this.gauge(0L, name + "-population", topologyId, componentId, taskId, port);
        return new JcMetrics(capacityGauge, populationGauge);
    }

    public Meter meter(String name, WorkerTopologyContext context, String componentId, Integer taskId, String streamId) {
        MetricNames metricNames = this.workerMetricName(name, context.getStormId(), componentId, streamId, taskId, context.getThisWorkerPort());
        Meter meter = this.registry.meter(metricNames.getLongName());
        StormMetricRegistry.saveMetricTaskIdMapping(taskId, metricNames, meter, this.taskIdMeters);
        return meter;
    }

    public Meter meter(String name, TopologyContext context) {
        MetricNames metricNames = this.topologyMetricName(name, context);
        Meter meter = this.registry.meter(metricNames.getLongName());
        StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, meter, this.taskIdMeters);
        return meter;
    }

    public Counter counter(String name, WorkerTopologyContext context, String componentId, Integer taskId, String streamId) {
        MetricNames metricNames = this.workerMetricName(name, context.getStormId(), componentId, streamId, taskId, context.getThisWorkerPort());
        Counter counter = this.registry.counter(metricNames.getLongName());
        StormMetricRegistry.saveMetricTaskIdMapping(taskId, metricNames, counter, this.taskIdCounters);
        return counter;
    }

    public Counter counter(String name, String topologyId, String componentId, Integer taskId, Integer workerPort, String streamId) {
        MetricNames metricNames = this.workerMetricName(name, topologyId, componentId, streamId, taskId, workerPort);
        Counter counter = this.registry.counter(metricNames.getLongName());
        StormMetricRegistry.saveMetricTaskIdMapping(taskId, metricNames, counter, this.taskIdCounters);
        return counter;
    }

    public Counter counter(String name, TopologyContext context) {
        MetricNames metricNames = this.topologyMetricName(name, context);
        Counter counter = this.registry.counter(metricNames.getLongName());
        StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, counter, this.taskIdCounters);
        return counter;
    }

    public void metricSet(String prefix, MetricSet set, TopologyContext context) {
        for (Map.Entry entry : set.getMetrics().entrySet()) {
            MetricNames metricNames = this.topologyMetricName(prefix + "." + (String)entry.getKey(), context);
            Metric metric = this.registry.register(metricNames.getLongName(), (Metric)entry.getValue());
            if (metric instanceof Gauge) {
                StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, (Gauge)metric, this.taskIdGauges);
                continue;
            }
            if (metric instanceof Meter) {
                StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, (Meter)metric, this.taskIdMeters);
                continue;
            }
            if (metric instanceof Counter) {
                StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, (Counter)metric, this.taskIdCounters);
                continue;
            }
            if (metric instanceof Timer) {
                StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, (Timer)metric, this.taskIdTimers);
                continue;
            }
            if (metric instanceof Histogram) {
                StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, (Histogram)metric, this.taskIdHistograms);
                continue;
            }
            LOG.error("Unable to save taskId mapping for metric {} named {}", (Object)metric, (Object)metricNames.getLongName());
        }
    }

    public Timer timer(String name, TopologyContext context) {
        MetricNames metricNames = this.topologyMetricName(name, context);
        Timer timer = this.registry.timer(metricNames.getLongName());
        StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, timer, this.taskIdTimers);
        return timer;
    }

    public Histogram histogram(String name, TopologyContext context) {
        MetricNames metricNames = this.topologyMetricName(name, context);
        Histogram histogram = this.registry.histogram(metricNames.getLongName());
        StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, histogram, this.taskIdHistograms);
        return histogram;
    }

    private static <T extends Metric> void saveMetricTaskIdMapping(Integer taskId, MetricNames names, T metric, Map<Integer, Map<String, T>> taskIdMetrics) {
        Map metrics = taskIdMetrics.computeIfAbsent(taskId, tid -> new HashMap());
        metrics.put(names.getV2TickName(), metric);
    }

    private <T extends Metric> Map<String, T> getMetricNameMap(int taskId, Map<Integer, Map<String, T>> taskIdMetrics) {
        HashMap ret = new HashMap();
        Map taskMetrics = taskIdMetrics.getOrDefault(taskId, Collections.emptyMap());
        ret.putAll(taskMetrics);
        return ret;
    }

    public Map<String, Gauge> getTaskGauges(int taskId) {
        return this.getMetricNameMap(taskId, this.taskIdGauges);
    }

    public Map<String, Counter> getTaskCounters(int taskId) {
        return this.getMetricNameMap(taskId, this.taskIdCounters);
    }

    public Map<String, Histogram> getTaskHistograms(int taskId) {
        return this.getMetricNameMap(taskId, this.taskIdHistograms);
    }

    public Map<String, Meter> getTaskMeters(int taskId) {
        return this.getMetricNameMap(taskId, this.taskIdMeters);
    }

    public Map<String, Timer> getTaskTimers(int taskId) {
        return this.getMetricNameMap(taskId, this.taskIdTimers);
    }

    public void start(Map<String, Object> stormConfig, DaemonType type) {
        try {
            this.hostName = this.dotToUnderScore(Utils.localHostname());
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to determine hostname while starting the metrics system. Hostname will be reported as 'localhost'.");
        }
        LOG.info("Starting metrics reporters...");
        List reporterList = (List)stormConfig.get("storm.metrics.reporters");
        if (reporterList != null && reporterList.size() > 0) {
            for (Map reporterConfig : reporterList) {
                List daemons = (List)reporterConfig.get("daemons");
                for (String daemon : daemons) {
                    if (DaemonType.valueOf(daemon.toUpperCase()) != type) continue;
                    this.startReporter(stormConfig, reporterConfig);
                }
            }
        }
    }

    private void startReporter(Map<String, Object> stormConfig, Map<String, Object> reporterConfig) {
        String clazz = (String)reporterConfig.get("class");
        LOG.info("Attempting to instantiate reporter class: {}", (Object)clazz);
        StormReporter reporter = (StormReporter)ReflectionUtils.newInstance(clazz);
        if (reporter != null) {
            reporter.prepare(this.registry, stormConfig, reporterConfig);
            reporter.start();
            this.reporters.add(reporter);
        }
    }

    public void stop() {
        for (StormReporter sr : this.reporters) {
            sr.stop();
        }
    }

    private MetricNames workerMetricName(String name, String stormId, String componentId, String streamId, Integer taskId, Integer workerPort) {
        StringBuilder sb = new StringBuilder(WORKER_METRIC_PREFIX);
        sb.append(stormId);
        sb.append(".");
        sb.append(this.hostName);
        sb.append(".");
        sb.append(this.dotToUnderScore(componentId));
        sb.append(".");
        sb.append(this.dotToUnderScore(streamId));
        sb.append(".");
        sb.append(taskId);
        sb.append(".");
        sb.append(workerPort);
        sb.append("-");
        sb.append(name);
        String longName = sb.toString();
        MetricNames names = new MetricNames(longName, name);
        return names;
    }

    private MetricNames workerMetricName(String name, String stormId, String componentId, Integer taskId, Integer workerPort) {
        StringBuilder sb = new StringBuilder(WORKER_METRIC_PREFIX);
        sb.append(stormId);
        sb.append(".");
        sb.append(this.hostName);
        sb.append(".");
        sb.append(this.dotToUnderScore(componentId));
        sb.append(".");
        sb.append(taskId);
        sb.append(".");
        sb.append(workerPort);
        sb.append("-");
        sb.append(name);
        String longName = sb.toString();
        MetricNames names = new MetricNames(longName, name);
        return names;
    }

    private MetricNames topologyMetricName(String name, TopologyContext context) {
        StringBuilder sb = new StringBuilder(TOPOLOGY_METRIC_PREFIX);
        sb.append(context.getStormId());
        sb.append(".");
        sb.append(this.hostName);
        sb.append(".");
        sb.append(this.dotToUnderScore(context.getThisComponentId()));
        sb.append(".");
        sb.append(context.getThisTaskId());
        sb.append(".");
        sb.append(context.getThisWorkerPort());
        sb.append("-");
        sb.append(name);
        String longName = sb.toString();
        MetricNames names = new MetricNames(longName, name);
        return names;
    }

    private String dotToUnderScore(String str) {
        return str.replace('.', '_');
    }

    private static class MetricNames {
        private String longName;
        private String shortName;

        MetricNames(String longName, String shortName) {
            this.longName = longName;
            this.shortName = shortName;
        }

        String getLongName() {
            return this.longName;
        }

        String getV2TickName() {
            return this.shortName;
        }
    }
}

