/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.storm.grouping.Load;
import org.apache.storm.messaging.ConnectionWithStatus;
import org.apache.storm.messaging.TaskMessage;
import org.apache.storm.messaging.netty.BackPressureStatus;
import org.apache.storm.messaging.netty.ISaslClient;
import org.apache.storm.messaging.netty.MessageBatch;
import org.apache.storm.messaging.netty.MessageBuffer;
import org.apache.storm.messaging.netty.SaslUtils;
import org.apache.storm.messaging.netty.StormClientPipelineFactory;
import org.apache.storm.metric.api.IStatefulObject;
import org.apache.storm.policy.IWaitStrategy;
import org.apache.storm.policy.WaitStrategyProgressive;
import org.apache.storm.shade.com.google.common.base.Preconditions;
import org.apache.storm.shade.io.netty.bootstrap.Bootstrap;
import org.apache.storm.shade.io.netty.buffer.PooledByteBufAllocator;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelFuture;
import org.apache.storm.shade.io.netty.channel.ChannelFutureListener;
import org.apache.storm.shade.io.netty.channel.ChannelHandler;
import org.apache.storm.shade.io.netty.channel.ChannelOption;
import org.apache.storm.shade.io.netty.channel.EventLoopGroup;
import org.apache.storm.shade.io.netty.channel.WriteBufferWaterMark;
import org.apache.storm.shade.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.storm.shade.io.netty.util.HashedWheelTimer;
import org.apache.storm.shade.io.netty.util.Timeout;
import org.apache.storm.shade.io.netty.util.TimerTask;
import org.apache.storm.shade.io.netty.util.concurrent.GenericFutureListener;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.StormBoundedExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
extends ConnectionWithStatus
implements IStatefulObject,
ISaslClient {
    private static final long PENDING_MESSAGES_FLUSH_TIMEOUT_MS = 600000L;
    private static final long PENDING_MESSAGES_FLUSH_INTERVAL_MS = 1000L;
    private static final long CHANNEL_ALIVE_INTERVAL_MS = 30000L;
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private static final String PREFIX = "Netty-Client-";
    private static final long NO_DELAY_MS = 0L;
    private static final Timer TIMER = new Timer("Netty-ChannelAlive-Timer", true);
    protected final String dstAddressPrefixedName;
    private final Map<String, Object> topoConf;
    private final StormBoundedExponentialBackoffRetry retryPolicy;
    private final EventLoopGroup eventLoopGroup;
    private final Bootstrap bootstrap;
    private final InetSocketAddress dstAddress;
    private final AtomicReference<Channel> channelRef = new AtomicReference();
    private final AtomicInteger totalConnectionAttempts = new AtomicInteger(0);
    private final AtomicInteger connectionAttempts = new AtomicInteger(0);
    private final AtomicInteger messagesSent = new AtomicInteger(0);
    private final AtomicInteger messagesLost = new AtomicInteger(0);
    private final AtomicLong pendingMessages = new AtomicLong(0L);
    private final AtomicBoolean saslChannelReady = new AtomicBoolean(false);
    private final HashedWheelTimer scheduler;
    private final MessageBuffer batcher;
    private final IWaitStrategy waitStrategy;
    private volatile Map<Integer, Double> serverLoad = null;
    private volatile boolean closing = false;

    Client(Map<String, Object> topoConf, AtomicBoolean[] remoteBpStatus, EventLoopGroup eventLoopGroup, HashedWheelTimer scheduler, String host, int port) {
        this.topoConf = topoConf;
        this.closing = false;
        this.scheduler = scheduler;
        int bufferSize = ObjectReader.getInt(topoConf.get("storm.messaging.netty.buffer_size"));
        int lowWatermark = ObjectReader.getInt(topoConf.get("storm.messaging.netty.buffer.low.watermark"));
        int highWatermark = ObjectReader.getInt(topoConf.get("storm.messaging.netty.buffer.high.watermark"));
        this.saslChannelReady.set(!ObjectReader.getBoolean(topoConf.get("storm.messaging.netty.authentication"), false));
        LOG.info("Creating Netty Client, connecting to {}:{}, bufferSize: {}, lowWatermark: {}, highWatermark: {}", new Object[]{host, port, bufferSize, lowWatermark, highWatermark});
        int minWaitMs = ObjectReader.getInt(topoConf.get("storm.messaging.netty.min_wait_ms"));
        int maxWaitMs = ObjectReader.getInt(topoConf.get("storm.messaging.netty.max_wait_ms"));
        this.retryPolicy = new StormBoundedExponentialBackoffRetry(minWaitMs, maxWaitMs, -1);
        this.eventLoopGroup = eventLoopGroup;
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_SNDBUF, (Object)bufferSize)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(lowWatermark, highWatermark))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).handler((ChannelHandler)new StormClientPipelineFactory(this, remoteBpStatus, topoConf));
        this.dstAddress = new InetSocketAddress(host, port);
        this.dstAddressPrefixedName = this.prefixedName(this.dstAddress);
        this.launchChannelAliveThread();
        this.scheduleConnect(0L);
        int messageBatchSize = ObjectReader.getInt(topoConf.get("storm.messaging.netty.transfer.batch.size"), 262144);
        this.batcher = new MessageBuffer(messageBatchSize);
        String clazz = (String)topoConf.get("topology.backpressure.wait.strategy");
        this.waitStrategy = clazz == null ? new WaitStrategyProgressive() : (IWaitStrategy)ReflectionUtils.newInstance(clazz);
        this.waitStrategy.prepare(topoConf, IWaitStrategy.WaitSituation.BACK_PRESSURE_WAIT);
    }

    private void launchChannelAliveThread() {
        TIMER.schedule(new java.util.TimerTask(){

            @Override
            public void run() {
                try {
                    LOG.debug("running timer task, address {}", (Object)Client.this.dstAddress);
                    if (Client.this.closing) {
                        this.cancel();
                        return;
                    }
                    Client.this.getConnectedChannel();
                }
                catch (Exception exp) {
                    LOG.error("channel connection error {}", (Throwable)exp);
                }
            }
        }, 0L, 30000L);
    }

    private String prefixedName(InetSocketAddress dstAddress) {
        if (null != dstAddress) {
            return PREFIX + dstAddress.toString();
        }
        return "";
    }

    private void scheduleConnect(long delayMs) {
        this.scheduler.newTimeout((TimerTask)new Connect(this.dstAddress), delayMs, TimeUnit.MILLISECONDS);
    }

    private boolean reconnectingAllowed() {
        return !this.closing;
    }

    private boolean connectionEstablished(Channel channel) {
        return channel != null && channel.isActive();
    }

    @Override
    public ConnectionWithStatus.Status status() {
        if (this.closing) {
            return ConnectionWithStatus.Status.Closed;
        }
        if (!this.connectionEstablished(this.channelRef.get())) {
            return ConnectionWithStatus.Status.Connecting;
        }
        if (this.saslChannelReady.get()) {
            return ConnectionWithStatus.Status.Ready;
        }
        return ConnectionWithStatus.Status.Connecting;
    }

    @Override
    public void sendLoadMetrics(Map<Integer, Double> taskToLoad) {
        throw new RuntimeException("Client connection should not send load metrics");
    }

    @Override
    public void sendBackPressureStatus(BackPressureStatus bpStatus) {
        throw new RuntimeException("Client connection should not send BackPressure status");
    }

    @Override
    public void send(Iterator<TaskMessage> msgs) {
        if (this.closing) {
            int numMessages = this.iteratorSize(msgs);
            LOG.error("Dropping {} messages because the Netty client to {} is being closed", (Object)numMessages, (Object)this.dstAddressPrefixedName);
            return;
        }
        if (!this.hasMessages(msgs)) {
            return;
        }
        Channel channel = this.getConnectedChannel();
        if (channel == null) {
            this.dropMessages(msgs);
            return;
        }
        try {
            while (msgs.hasNext()) {
                TaskMessage message = msgs.next();
                MessageBatch batch = this.batcher.add(message);
                if (batch == null) continue;
                this.writeMessage(channel, batch);
            }
            MessageBatch batch = this.batcher.drain();
            if (batch != null) {
                this.writeMessage(channel, batch);
            }
        }
        catch (IOException e) {
            LOG.warn("Exception when sending message to remote worker.", (Throwable)e);
            this.dropMessages(msgs);
        }
    }

    private void writeMessage(Channel channel, MessageBatch batch) throws IOException {
        try {
            int idleCounter = 0;
            while (!channel.isWritable()) {
                if (idleCounter == 0) {
                    LOG.debug("Experiencing Back Pressure from Netty. Entering BackPressure Wait");
                }
                if (!channel.isActive()) {
                    throw new IOException("Connection disconnected");
                }
                idleCounter = this.waitStrategy.idle(idleCounter);
            }
            this.flushMessages(channel, batch);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Channel getConnectedChannel() {
        Channel channel = this.channelRef.get();
        if (this.connectionEstablished(channel)) {
            return channel;
        }
        boolean reconnectScheduled = this.closeChannelAndReconnect(channel);
        if (reconnectScheduled) {
            LOG.error("connection to {} is unavailable", (Object)this.dstAddressPrefixedName);
        }
        return null;
    }

    public InetSocketAddress getDstAddress() {
        return this.dstAddress;
    }

    private boolean hasMessages(Iterator<TaskMessage> msgs) {
        return msgs != null && msgs.hasNext();
    }

    private void dropMessages(Iterator<TaskMessage> msgs) {
        int msgCount = this.iteratorSize(msgs);
        this.messagesLost.getAndAdd(msgCount);
        LOG.info("Dropping {} messages", (Object)msgCount);
    }

    private int iteratorSize(Iterator<TaskMessage> msgs) {
        int size = 0;
        if (msgs != null) {
            while (msgs.hasNext()) {
                ++size;
                msgs.next();
            }
        }
        return size;
    }

    private void flushMessages(Channel channel, final MessageBatch batch) {
        if (null == batch || batch.isEmpty()) {
            return;
        }
        final int numMessages = batch.size();
        LOG.debug("writing {} messages to channel {}", (Object)batch.size(), (Object)channel.toString());
        this.pendingMessages.addAndGet(numMessages);
        ChannelFuture future = channel.writeAndFlush((Object)batch);
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Client.this.pendingMessages.addAndGet(0 - numMessages);
                if (future.isSuccess()) {
                    LOG.debug("sent {} messages to {}", (Object)numMessages, (Object)Client.this.dstAddressPrefixedName);
                    Client.this.messagesSent.getAndAdd(batch.size());
                } else {
                    LOG.error("failed to send {} messages to {}: {}", new Object[]{numMessages, Client.this.dstAddressPrefixedName, future.cause()});
                    Client.this.closeChannelAndReconnect(future.channel());
                    Client.this.messagesLost.getAndAdd(numMessages);
                }
            }
        });
    }

    private boolean closeChannelAndReconnect(Channel channel) {
        if (channel != null) {
            channel.close();
            if (this.channelRef.compareAndSet(channel, null)) {
                this.scheduleConnect(0L);
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPort() {
        return this.dstAddress.getPort();
    }

    @Override
    public void close() {
        if (!this.closing) {
            LOG.info("closing Netty Client {}", (Object)this.dstAddressPrefixedName);
            this.closing = true;
            this.waitForPendingMessagesToBeSent();
            this.closeChannel();
        }
    }

    private void waitForPendingMessagesToBeSent() {
        LOG.info("waiting up to {} ms to send {} pending messages to {}", new Object[]{600000L, this.pendingMessages.get(), this.dstAddressPrefixedName});
        long totalPendingMsgs = this.pendingMessages.get();
        long startMs = System.currentTimeMillis();
        while (this.pendingMessages.get() != 0L) {
            try {
                long deltaMs = System.currentTimeMillis() - startMs;
                if (deltaMs > 600000L) {
                    LOG.error("failed to send all pending messages to {} within timeout, {} of {} messages were not sent", new Object[]{this.dstAddressPrefixedName, this.pendingMessages.get(), totalPendingMsgs});
                    break;
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private void closeChannel() {
        Channel channel = this.channelRef.get();
        if (channel != null) {
            channel.close();
            LOG.debug("channel to {} closed", (Object)this.dstAddressPrefixedName);
        }
    }

    void setLoadMetrics(Map<Integer, Double> taskToLoad) {
        this.serverLoad = taskToLoad;
    }

    @Override
    public Map<Integer, Load> getLoad(Collection<Integer> tasks) {
        Map<Integer, Double> loadCache = this.serverLoad;
        HashMap<Integer, Load> ret = new HashMap<Integer, Load>();
        if (loadCache != null) {
            double clientLoad = (double)Math.min(this.pendingMessages.get(), 1024L) / 1024.0;
            for (Integer task : tasks) {
                Double found = loadCache.get(task);
                if (found == null) continue;
                ret.put(task, new Load(true, found, clientLoad));
            }
        }
        return ret;
    }

    @Override
    public Object getState() {
        LOG.debug("Getting metrics for client connection to {}", (Object)this.dstAddressPrefixedName);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("reconnects", this.totalConnectionAttempts.getAndSet(0));
        ret.put("sent", this.messagesSent.getAndSet(0));
        ret.put("pending", this.pendingMessages.get());
        ret.put("lostOnSend", this.messagesLost.getAndSet(0));
        ret.put("dest", this.dstAddress.toString());
        String src = this.srcAddressName();
        if (src != null) {
            ret.put("src", src);
        }
        return ret;
    }

    public Map<String, Object> getConfig() {
        return this.topoConf;
    }

    @Override
    public void channelReady(Channel channel) {
        this.saslChannelReady.set(true);
    }

    @Override
    public String name() {
        return (String)this.topoConf.get("topology.name");
    }

    @Override
    public String secretKey() {
        return SaslUtils.getSecretKey(this.topoConf);
    }

    private String srcAddressName() {
        SocketAddress address;
        String name = null;
        Channel channel = this.channelRef.get();
        if (channel != null && (address = channel.localAddress()) != null) {
            name = address.toString();
        }
        return name;
    }

    public String toString() {
        return String.format("Netty client for connecting to %s", this.dstAddressPrefixedName);
    }

    private class Connect
    implements TimerTask {
        private final InetSocketAddress address;

        Connect(InetSocketAddress address) {
            this.address = address;
        }

        private void reschedule(Throwable t) {
            String baseMsg = String.format("connection attempt %s to %s failed", Client.this.connectionAttempts, Client.this.dstAddressPrefixedName);
            String failureMsg = t == null ? baseMsg : baseMsg + ": " + t.toString();
            LOG.error(failureMsg);
            long nextDelayMs = Client.this.retryPolicy.getSleepTimeMs(Client.this.connectionAttempts.get(), 0L);
            Client.this.scheduleConnect(nextDelayMs);
        }

        public void run(Timeout timeout) throws Exception {
            if (!Client.this.reconnectingAllowed()) {
                Client.this.close();
                throw new RuntimeException("Giving up to scheduleConnect to " + Client.this.dstAddressPrefixedName + " after " + Client.this.connectionAttempts + " failed attempts. " + Client.this.messagesLost.get() + " messages were lost");
            }
            final int connectionAttempt = Client.this.connectionAttempts.getAndIncrement();
            Client.this.totalConnectionAttempts.getAndIncrement();
            LOG.debug("connecting to {} [attempt {}]", (Object)this.address.toString(), (Object)connectionAttempt);
            ChannelFuture future = Client.this.bootstrap.connect((SocketAddress)this.address);
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    Channel newChannel = future.channel();
                    if (future.isSuccess() && Client.this.connectionEstablished(newChannel)) {
                        boolean setChannel = Client.this.channelRef.compareAndSet(null, newChannel);
                        Preconditions.checkState((boolean)setChannel);
                        LOG.debug("successfully connected to {}, {} [attempt {}]", new Object[]{Connect.this.address.toString(), newChannel.toString(), connectionAttempt});
                        if (Client.this.messagesLost.get() > 0) {
                            LOG.warn("Re-connection to {} was successful but {} messages has been lost so far", (Object)Connect.this.address.toString(), (Object)Client.this.messagesLost.get());
                        }
                    } else {
                        Throwable cause = future.cause();
                        Connect.this.reschedule(cause);
                        if (newChannel != null) {
                            newChannel.close();
                        }
                    }
                }
            });
        }
    }
}

