/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.storm.messaging.IContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportFactory {
    public static final Logger LOG = LoggerFactory.getLogger(TransportFactory.class);

    public static IContext makeContext(Map<String, Object> topoConf) {
        IContext transport;
        String transportPluginClassName = (String)topoConf.get("storm.messaging.transport");
        LOG.info("Storm peer transport plugin:" + transportPluginClassName);
        try {
            Class<?> klass = Class.forName(transportPluginClassName);
            Object obj = klass.newInstance();
            if (obj instanceof IContext) {
                transport = (IContext)obj;
                transport.prepare(topoConf);
            } else {
                Method method = klass.getMethod("makeContext", Map.class);
                LOG.debug("object:" + obj + " method:" + method);
                transport = (IContext)method.invoke(obj, topoConf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to construct messaging plugin from plugin " + transportPluginClassName, e);
        }
        return transport;
    }
}

