/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.executor.spout;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.storm.daemon.Task;
import org.apache.storm.executor.TupleInfo;
import org.apache.storm.executor.spout.SpoutExecutor;
import org.apache.storm.spout.ISpout;
import org.apache.storm.spout.ISpoutOutputCollector;
import org.apache.storm.tuple.AddressedTuple;
import org.apache.storm.tuple.MessageId;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.MutableLong;
import org.apache.storm.utils.RotatingMap;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpoutOutputCollectorImpl
implements ISpoutOutputCollector {
    private static final Logger LOG = LoggerFactory.getLogger(SpoutOutputCollectorImpl.class);
    private final SpoutExecutor executor;
    private final Task taskData;
    private final int taskId;
    private final MutableLong emittedCount;
    private final boolean hasAckers;
    private final Random random;
    private final Boolean isEventLoggers;
    private final Boolean isDebug;
    private final RotatingMap<Long, TupleInfo> pending;
    private final long spoutExecutorThdId;
    private TupleInfo globalTupleInfo = new TupleInfo();

    public SpoutOutputCollectorImpl(ISpout spout, SpoutExecutor executor, Task taskData, MutableLong emittedCount, boolean hasAckers, Random random, Boolean isEventLoggers, Boolean isDebug, RotatingMap<Long, TupleInfo> pending) {
        this.executor = executor;
        this.taskData = taskData;
        this.taskId = taskData.getTaskId();
        this.emittedCount = emittedCount;
        this.hasAckers = hasAckers;
        this.random = random;
        this.isEventLoggers = isEventLoggers;
        this.isDebug = isDebug;
        this.pending = pending;
        this.spoutExecutorThdId = executor.getThreadId();
    }

    @Override
    public List<Integer> emit(String streamId, List<Object> tuple, Object messageId) {
        try {
            return this.sendSpoutMsg(streamId, tuple, messageId, null);
        }
        catch (InterruptedException e) {
            LOG.warn("Spout thread interrupted during emit().");
            throw new RuntimeException(e);
        }
    }

    @Override
    public void emitDirect(int taskId, String streamId, List<Object> tuple, Object messageId) {
        try {
            this.sendSpoutMsg(streamId, tuple, messageId, taskId);
        }
        catch (InterruptedException e) {
            LOG.warn("Spout thread interrupted during emitDirect().");
            throw new RuntimeException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.executor.getExecutorTransfer().flush();
        }
        catch (InterruptedException e) {
            LOG.warn("Spout thread interrupted during flush().");
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getPendingCount() {
        return this.pending.size();
    }

    @Override
    public void reportError(Throwable error) {
        this.executor.getErrorReportingMetrics().incrReportedErrorCount();
        this.executor.getReportError().report(error);
    }

    private List<Integer> sendSpoutMsg(String stream, List<Object> values, Object messageId, Integer outTaskId) throws InterruptedException {
        this.emittedCount.increment();
        List<Integer> outTasks = outTaskId != null ? this.taskData.getOutgoingTasks(outTaskId, stream, values) : this.taskData.getOutgoingTasks(stream, values);
        boolean needAck = messageId != null && this.hasAckers;
        ArrayList<Long> ackSeq = needAck ? new ArrayList<Long>() : null;
        long rootId = needAck ? MessageId.generateId(this.random) : 0L;
        for (int i = 0; i < outTasks.size(); ++i) {
            MessageId msgId;
            Integer t = outTasks.get(i);
            if (needAck) {
                long as = MessageId.generateId(this.random);
                msgId = MessageId.makeRootId(rootId, as);
                ackSeq.add(as);
            } else {
                msgId = MessageId.makeUnanchored();
            }
            TupleImpl tuple = new TupleImpl(this.executor.getWorkerTopologyContext(), values, this.executor.getComponentId(), this.taskId, stream, msgId);
            AddressedTuple adrTuple = new AddressedTuple(t, tuple);
            this.executor.getExecutorTransfer().tryTransfer(adrTuple, this.executor.getPendingEmits());
        }
        if (this.isEventLoggers.booleanValue()) {
            this.taskData.sendToEventLogger(this.executor, values, this.executor.getComponentId(), messageId, this.random, this.executor.getPendingEmits());
        }
        if (needAck) {
            boolean sample;
            TupleInfo info = new TupleInfo();
            info.setTaskId(this.taskId);
            info.setStream(stream);
            info.setMessageId(messageId);
            info.setRootId(rootId);
            if (this.isDebug.booleanValue()) {
                info.setValues(values);
            }
            if (sample = this.executor.samplerCheck()) {
                info.setTimestamp(System.currentTimeMillis());
            }
            this.pending.put(rootId, info);
            Values ackInitTuple = new Values(rootId, Utils.bitXorVals(ackSeq), this.taskId);
            this.taskData.sendUnanchored("__ack_init", ackInitTuple, this.executor.getExecutorTransfer(), this.executor.getPendingEmits());
        } else if (messageId != null) {
            if (this.isDebug.booleanValue() && this.spoutExecutorThdId != Thread.currentThread().getId()) {
                throw new RuntimeException("Detected background thread emitting tuples for the spout. Spout Output Collector should only emit from the main spout executor thread.");
            }
            this.globalTupleInfo.clear();
            this.globalTupleInfo.setStream(stream);
            this.globalTupleInfo.setValues(values);
            this.globalTupleInfo.setMessageId(messageId);
            this.globalTupleInfo.setTimestamp(0L);
            this.globalTupleInfo.setRootId(rootId);
            Long timeDelta = 0L;
            this.executor.ackSpoutMsg(this.executor, this.taskData, timeDelta, this.globalTupleInfo);
        }
        return outTasks;
    }
}

