/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.generated.NodeInfo;
import org.apache.storm.messaging.IConnection;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.api.IStatefulObject;
import org.apache.storm.metric.api.StateMetric;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.utils.JCQueue;

public class BuiltinMetricsUtil {
    public static void registerIconnectionServerMetric(Object server, Map<String, Object> topoConf, TopologyContext context) {
        if (server instanceof IStatefulObject) {
            BuiltinMetricsUtil.registerMetric("__recv-iconnection", new StateMetric((IStatefulObject)server), topoConf, context);
        }
    }

    public static void registerIconnectionClientMetrics(final Map<NodeInfo, IConnection> nodePortToSocket, Map<String, Object> topoConf, TopologyContext context) {
        IMetric metric = new IMetric(){

            @Override
            public Object getValueAndReset() {
                HashMap<NodeInfo, Object> ret = new HashMap<NodeInfo, Object>();
                for (Map.Entry entry : nodePortToSocket.entrySet()) {
                    NodeInfo nodePort = (NodeInfo)entry.getKey();
                    IConnection connection = (IConnection)entry.getValue();
                    if (!(connection instanceof IStatefulObject)) continue;
                    ret.put(nodePort, ((IStatefulObject)((Object)connection)).getState());
                }
                return ret;
            }
        };
        BuiltinMetricsUtil.registerMetric("__send-iconnection", metric, topoConf, context);
    }

    public static void registerQueueMetrics(Map<String, JCQueue> queues, Map<String, Object> topoConf, TopologyContext context) {
        for (Map.Entry<String, JCQueue> entry : queues.entrySet()) {
            String name = "__" + entry.getKey();
            StateMetric metric = new StateMetric(entry.getValue());
            BuiltinMetricsUtil.registerMetric(name, metric, topoConf, context);
        }
    }

    public static void registerMetric(String name, IMetric metric, Map<String, Object> topoConf, TopologyContext context) {
        int bucketSize = ((Number)topoConf.get("topology.builtin.metrics.bucket.size.secs")).intValue();
        context.registerMetric(name, metric, bucketSize);
    }
}

