/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.security;

import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.apache.commons.io.FileUtils;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.server.services.security.SecurityStore;
import org.apache.slider.server.services.security.SecurityUtils;
import org.apache.slider.server.services.security.SignCertResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CertificateManager {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateManager.class);
    private static final String GEN_SRVR_KEY = "openssl genrsa -des3 -passout pass:{0} -out {1}" + File.separator + "{2} 4096 ";
    private static final String GEN_SRVR_REQ = "openssl req -passin pass:{0} -new -key {1}" + File.separator + "{2} -out {1}" + File.separator + "{5} -config {1}" + File.separator + "ca.config " + "-subj {6} -batch";
    private static final String SIGN_SRVR_CRT = "openssl ca -create_serial -out {1}" + File.separator + "{3} -days 365 -keyfile {1}" + File.separator + "{2} -key {0} -selfsign -extensions jdk7_ca -config {1}" + File.separator + "ca.config -batch -infiles {1}" + File.separator + "{5}";
    private static final String EXPRT_KSTR = "openssl pkcs12 -export -in {2}" + File.separator + "{4} -inkey {2}" + File.separator + "{3} -certfile {2}" + File.separator + "{4} -out {2}" + File.separator + "{5} -password pass:{1} -passin pass:{0} \n";
    private static final String REVOKE_AGENT_CRT = "openssl ca -config {0}" + File.separator + "ca.config -keyfile {0}" + File.separator + "{4} -revoke {0}" + File.separator + "{2} -batch " + "-passin pass:{3} -cert {0}" + File.separator + "{5}";
    private static final String SIGN_AGENT_CRT = "openssl ca -config {0}" + File.separator + "ca.config -in {0}" + File.separator + "{1} -out {0}" + File.separator + "{2} -batch -passin pass:{3} " + "-keyfile {0}" + File.separator + "{4} -cert {0}" + File.separator + "{5}";
    private static final String GEN_AGENT_KEY = "openssl req -new -newkey rsa:1024 -nodes -keyout {0}" + File.separator + "{2}.key -subj {1} -out {0}" + File.separator + "{2}.csr " + "-config {3}" + File.separator + "ca.config ";
    private String passphrase;
    private String applicationName;

    public void initialize(MapOperations compOperations) throws SliderException {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            hostname = "localhost";
        }
        this.initialize(compOperations, hostname, null, null);
    }

    public void initialize(MapOperations compOperations, String hostname, String containerId, String appName) throws SliderException {
        SecurityUtils.initializeSecurityParameters(compOperations);
        LOG.info("Initialization of root certificate");
        boolean certExists = this.isCertExists();
        LOG.info("Certificate exists:" + certExists);
        this.applicationName = appName;
        if (!certExists) {
            this.generateAMKeystore(hostname, containerId);
        }
    }

    private boolean isCertExists() {
        String srvrKstrDir = SecurityUtils.getSecurityDir();
        String srvrCrtName = "ca.crt";
        File certFile = new File(String.valueOf(srvrKstrDir) + File.separator + srvrCrtName);
        LOG.debug("srvrKstrDir = " + srvrKstrDir);
        LOG.debug("srvrCrtName = " + srvrCrtName);
        LOG.debug("certFile = " + certFile.getAbsolutePath());
        return certFile.exists();
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    private int runCommand(String command) throws SliderException {
        int exitCode;
        block15: {
            exitCode = -1;
            Process process = null;
            BufferedReader br = null;
            try {
                try {
                    process = Runtime.getRuntime().exec(command);
                    StreamConsumer outputConsumer = new StreamConsumer(process.getInputStream(), true);
                    StreamConsumer errorConsumer = new StreamConsumer(process.getErrorStream(), true);
                    outputConsumer.start();
                    errorConsumer.start();
                    try {
                        process.waitFor();
                        SecurityUtils.logOpenSslExitCode(command, process.exitValue());
                        exitCode = process.exitValue();
                        if (exitCode != 0) {
                            throw new SliderException(exitCode, "Error running command %s", command);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (br == null) break block15;
                    try {
                        br.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        }
        return exitCode;
    }

    public synchronized void generateContainerCertificate(String hostname, String identifier) {
        LOG.info("Generation of certificate for {}", (Object)hostname);
        String srvrKstrDir = SecurityUtils.getSecurityDir();
        Object[] scriptArgs = new Object[]{srvrKstrDir, this.getSubjectDN(hostname, identifier, this.applicationName), identifier, SecurityUtils.getSecurityDir()};
        try {
            String command = MessageFormat.format(GEN_AGENT_KEY, scriptArgs);
            this.runCommand(command);
            this.signAgentCertificate(identifier);
        }
        catch (SliderException e) {
            LOG.error("Error generating the agent certificate", (Throwable)((Object)e));
        }
    }

    public synchronized SecurityStore generateContainerKeystore(String hostname, String requesterId, String role, String keystorePass) throws SliderException {
        LOG.info("Generation of container keystore for container {} on {}", (Object)requesterId, (Object)hostname);
        this.generateContainerCertificate(hostname, requesterId);
        String srvrCrtPass = SecurityUtils.getKeystorePass();
        String srvrKstrDir = SecurityUtils.getSecurityDir();
        String containerCrtName = String.valueOf(requesterId) + ".crt";
        String containerKeyName = String.valueOf(requesterId) + ".key";
        String kstrName = CertificateManager.getKeystoreFileName(requesterId, role);
        Object[] scriptArgs = new Object[]{srvrCrtPass, keystorePass, srvrKstrDir, containerKeyName, containerCrtName, kstrName};
        String command = MessageFormat.format(EXPRT_KSTR, scriptArgs);
        this.runCommand(command);
        return new SecurityStore(new File(srvrKstrDir, kstrName), SecurityStore.StoreType.keystore);
    }

    private static String getKeystoreFileName(String containerId, String role) {
        return String.format("keystore-%s-%s.p12", containerId, role != null ? role : "");
    }

    private void generateAMKeystore(String hostname, String containerId) throws SliderException {
        LOG.info("Generation of server certificate");
        String srvrKstrDir = SecurityUtils.getSecurityDir();
        String srvrCrtName = "ca.crt";
        String srvrCsrName = "ca.csr";
        String srvrKeyName = "ca.key";
        String kstrName = "keystore.p12";
        String srvrCrtPass = SecurityUtils.getKeystorePass();
        Object[] scriptArgs = new Object[]{srvrCrtPass, srvrKstrDir, srvrKeyName, srvrCrtName, kstrName, srvrCsrName, this.getSubjectDN(hostname, containerId, this.applicationName)};
        String command = MessageFormat.format(GEN_SRVR_KEY, scriptArgs);
        this.runCommand(command);
        command = MessageFormat.format(GEN_SRVR_REQ, scriptArgs);
        this.runCommand(command);
        command = MessageFormat.format(SIGN_SRVR_CRT, scriptArgs);
        this.runCommand(command);
        Object[] keystoreArgs = new Object[]{srvrCrtPass, srvrCrtPass, srvrKstrDir, srvrKeyName, srvrCrtName, kstrName, srvrCsrName};
        command = MessageFormat.format(EXPRT_KSTR, keystoreArgs);
        this.runCommand(command);
    }

    public SecurityStore generateContainerTruststore(String containerId, String role, String truststorePass) throws SliderException {
        String srvrKstrDir = SecurityUtils.getSecurityDir();
        String srvrCrtName = "ca.crt";
        String srvrCsrName = "ca.csr";
        String srvrKeyName = "ca.key";
        String kstrName = CertificateManager.getTruststoreFileName(role, containerId);
        String srvrCrtPass = SecurityUtils.getKeystorePass();
        Object[] scriptArgs = new Object[]{srvrCrtPass, truststorePass, srvrKstrDir, srvrKeyName, srvrCrtName, kstrName, srvrCsrName};
        String command = MessageFormat.format(EXPRT_KSTR, scriptArgs);
        this.runCommand(command);
        return new SecurityStore(new File(srvrKstrDir, kstrName), SecurityStore.StoreType.truststore);
    }

    private static String getTruststoreFileName(String role, String containerId) {
        return String.format("truststore-%s-%s.p12", containerId, role != null ? role : "");
    }

    public String getServerCert() {
        File certFile = CertificateManager.getServerCertficateFilePath();
        String srvrCrtContent = null;
        try {
            srvrCrtContent = FileUtils.readFileToString((File)certFile);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
        return srvrCrtContent;
    }

    public static File getServerCertficateFilePath() {
        return new File(String.format("%s%s%s", SecurityUtils.getSecurityDir(), File.separator, "ca.crt"));
    }

    public static File getAgentCertficateFilePath(String containerId) {
        return new File(String.format("%s%s%s.crt", SecurityUtils.getSecurityDir(), File.separator, containerId));
    }

    public static File getContainerKeystoreFilePath(String containerId, String role) {
        return new File(SecurityUtils.getSecurityDir(), CertificateManager.getKeystoreFileName(containerId, role));
    }

    public static File getContainerTruststoreFilePath(String role, String containerId) {
        return new File(SecurityUtils.getSecurityDir(), CertificateManager.getTruststoreFileName(role, containerId));
    }

    public static File getAgentKeyFilePath(String containerId) {
        return new File(String.format("%s%s%s.key", SecurityUtils.getSecurityDir(), File.separator, containerId));
    }

    public synchronized SignCertResponse signAgentCrt(String agentHostname, String agentCrtReqContent, String passphraseAgent) {
        SignCertResponse response = new SignCertResponse();
        LOG.info("Signing of agent certificate");
        LOG.info("Verifying passphrase");
        if (!this.passphrase.equals(passphraseAgent.trim())) {
            LOG.warn("Incorrect passphrase from the agent");
            response.setResult("ERROR");
            response.setMessage("Incorrect passphrase from the agent");
            return response;
        }
        String srvrKstrDir = SecurityUtils.getSecurityDir();
        String srvrCrtPass = SecurityUtils.getKeystorePass();
        String srvrCrtName = "ca.crt";
        String srvrKeyName = "ca.key";
        String agentCrtReqName = String.valueOf(agentHostname) + ".csr";
        String agentCrtName = String.valueOf(agentHostname) + ".crt";
        Object[] scriptArgs = new Object[]{srvrKstrDir, agentCrtReqName, agentCrtName, srvrCrtPass, srvrKeyName, srvrCrtName};
        File agentCrtFile = new File(String.valueOf(srvrKstrDir) + File.separator + agentCrtName);
        String command = null;
        if (agentCrtFile.exists()) {
            LOG.info("Revoking of " + agentHostname + " certificate.");
            command = MessageFormat.format(REVOKE_AGENT_CRT, scriptArgs);
            try {
                this.runCommand(command);
            }
            catch (SliderException e) {
                int commandExitCode = e.getExitCode();
                response.setResult("ERROR");
                response.setMessage(SecurityUtils.getOpenSslCommandResult(command, commandExitCode));
                return response;
            }
        }
        File agentCrtReqFile = new File(String.valueOf(srvrKstrDir) + File.separator + agentCrtReqName);
        try {
            FileUtils.writeStringToFile((File)agentCrtReqFile, (String)agentCrtReqContent);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        command = MessageFormat.format(SIGN_AGENT_CRT, scriptArgs);
        LOG.debug(SecurityUtils.hideOpenSslPassword(command));
        try {
            this.runCommand(command);
        }
        catch (SliderException e) {
            int commandExitCode = e.getExitCode();
            response.setResult("ERROR");
            response.setMessage(SecurityUtils.getOpenSslCommandResult(command, commandExitCode));
            return response;
        }
        String agentCrtContent = "";
        try {
            agentCrtContent = FileUtils.readFileToString((File)agentCrtFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error("Error reading signed agent certificate");
            response.setResult("ERROR");
            response.setMessage("Error reading signed agent certificate");
            return response;
        }
        response.setResult("OK");
        response.setSignedCa(agentCrtContent);
        return response;
    }

    private String signAgentCertificate(String containerId) throws SliderException {
        String command;
        String srvrKstrDir = SecurityUtils.getSecurityDir();
        String srvrCrtPass = SecurityUtils.getKeystorePass();
        String srvrCrtName = "ca.crt";
        String srvrKeyName = "ca.key";
        String agentCrtReqName = String.valueOf(containerId) + ".csr";
        String agentCrtName = String.valueOf(containerId) + ".crt";
        if (!new File(srvrKstrDir, srvrCrtName).exists()) {
            throw new SliderException("CA certificate not generated");
        }
        Object[] scriptArgs = new Object[]{srvrKstrDir, agentCrtReqName, agentCrtName, srvrCrtPass, srvrKeyName, srvrCrtName};
        File agentCrtFile = new File(String.valueOf(srvrKstrDir) + File.separator + agentCrtName);
        if (agentCrtFile.exists()) {
            LOG.info("Revoking of " + containerId + " certificate.");
            command = MessageFormat.format(REVOKE_AGENT_CRT, scriptArgs);
            this.runCommand(command);
        }
        command = MessageFormat.format(SIGN_AGENT_CRT, scriptArgs);
        LOG.debug(SecurityUtils.hideOpenSslPassword(command));
        this.runCommand(command);
        return agentCrtName;
    }

    private String getSubjectDN(String hostname, String containerId, String appName) {
        return String.format("/CN=%s%s%s", hostname, containerId != null ? "/OU=" + containerId : "", appName != null ? "/OU=" + appName : "");
    }

    class StreamConsumer
    extends Thread {
        InputStream is;
        boolean logOutput;

        StreamConsumer(InputStream is, boolean logOutput) {
            this.is = is;
            this.logOutput = logOutput;
        }

        StreamConsumer(InputStream is) {
            this(is, false);
        }

        @Override
        public void run() {
            try {
                String line;
                InputStreamReader isr = new InputStreamReader(this.is, Charset.forName("UTF8"));
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    if (!this.logOutput) continue;
                    LOG.info(line);
                }
            }
            catch (IOException e) {
                LOG.error("Error during processing of process stream", (Throwable)e);
            }
        }
    }
}

