/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.servicemonitor;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.slider.server.servicemonitor.Probe;
import org.apache.slider.server.servicemonitor.ProbeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProbe
extends Probe {
    protected static final Logger log = LoggerFactory.getLogger(HttpProbe.class);
    private final URL url;
    private final int timeout;
    private final int min;
    private final int max;

    public HttpProbe(URL url, int timeout, int min, int max, Configuration conf) throws IOException {
        super("Http probe of " + url + " [" + min + "-" + max + "]", conf);
        this.url = url;
        this.timeout = timeout;
        this.min = min;
        this.max = max;
    }

    public static HttpURLConnection getConnection(URL url, int timeout) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(true);
        connection.setConnectTimeout(timeout);
        return connection;
    }

    @Override
    public ProbeStatus ping(boolean livePing) {
        ProbeStatus status;
        block8: {
            status = new ProbeStatus();
            HttpURLConnection connection = null;
            try {
                try {
                    log.isDebugEnabled();
                    connection = HttpProbe.getConnection(this.url, this.timeout);
                    int rc = connection.getResponseCode();
                    if (rc < this.min || rc > this.max) {
                        String error = "Probe " + this.url + " error code: " + rc;
                        log.info(error);
                        status.fail(this, new IOException(error));
                        break block8;
                    }
                    status.succeed(this);
                }
                catch (IOException e) {
                    String error = "Probe " + this.url + " failed: " + e;
                    log.info(error, (Throwable)e);
                    status.fail(this, new IOException(error, e));
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return status;
    }
}

