/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpFilter;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpPrincipal;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsecureAmFilter
extends AmIpFilter {
    public static final String WS_CONTEXT_ROOT = "slider.rest.context.root";
    protected static final Logger log = LoggerFactory.getLogger(InsecureAmFilter.class);
    private String wsContextRoot;

    public void init(FilterConfig conf) throws ServletException {
        super.init(conf);
        this.wsContextRoot = conf.getInitParameter(WS_CONTEXT_ROOT);
        if (this.wsContextRoot == null) {
            throw new ServletException("No value set for slider.rest.context.root");
        }
    }

    private void rejectNonHttpRequests(ServletRequest req) throws ServletException {
        if (!(req instanceof HttpServletRequest)) {
            throw new ServletException("This filter only works for HTTP/HTTPS");
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        this.rejectNonHttpRequests(req);
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse cfr_ignored_0 = (HttpServletResponse)resp;
        String requestURI = httpReq.getRequestURI();
        if (requestURI == null || !requestURI.startsWith(this.wsContextRoot)) {
            super.doFilter(req, resp, chain);
            return;
        }
        String user = null;
        if (httpReq.getCookies() != null) {
            Cookie[] cookieArray = httpReq.getCookies();
            int n = cookieArray.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie c = cookieArray[n2];
                if ("proxy-user".equals(c.getName())) {
                    user = c.getValue();
                    break;
                }
                ++n2;
            }
        }
        if (user == null) {
            log.debug("Could not find proxy-user cookie, so user will not be set");
            chain.doFilter(req, resp);
        } else {
            AmIpPrincipal principal = new AmIpPrincipal(user);
            AmIpServletRequestWrapper requestWrapper = new AmIpServletRequestWrapper(httpReq, principal);
            chain.doFilter((ServletRequest)requestWrapper, resp);
        }
    }
}

