/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.slider.api.ClusterDescription;
import org.apache.slider.api.ClusterNode;
import org.apache.slider.api.types.ApplicationLivenessInformation;
import org.apache.slider.api.types.ComponentInformation;
import org.apache.slider.api.types.NodeInformation;
import org.apache.slider.api.types.RoleStatistics;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.exceptions.NoSuchNodeException;
import org.apache.slider.core.registry.docstore.PublishedConfigSet;
import org.apache.slider.core.registry.docstore.PublishedExportsSet;
import org.apache.slider.server.appmaster.state.AppState;
import org.apache.slider.server.appmaster.state.RoleInstance;
import org.apache.slider.server.appmaster.state.RoleStatus;
import org.apache.slider.server.appmaster.state.StateAccessForProviders;
import org.apache.slider.server.services.utility.PatternValidator;

public class ProviderAppState
implements StateAccessForProviders {
    private final Map<String, PublishedConfigSet> publishedConfigSets = new ConcurrentHashMap<String, PublishedConfigSet>(5);
    private final PublishedExportsSet publishedExportsSets = new PublishedExportsSet();
    private static final PatternValidator validator = new PatternValidator("[a-z0-9][a-z0-9_.\\+-]*");
    private String applicationName;
    private final AppState appState;

    public ProviderAppState(String applicationName, AppState appState) {
        this.appState = appState;
        this.applicationName = applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public PublishedConfigSet getPublishedSliderConfigurations() {
        return this.getOrCreatePublishedConfigSet("slider");
    }

    @Override
    public PublishedExportsSet getPublishedExportsSet() {
        return this.publishedExportsSets;
    }

    @Override
    public PublishedConfigSet getPublishedConfigSet(String name) {
        return this.publishedConfigSets.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublishedConfigSet getOrCreatePublishedConfigSet(String name) {
        PublishedConfigSet set = this.publishedConfigSets.get(name);
        if (set == null) {
            validator.validate(name);
            Map<String, PublishedConfigSet> map = this.publishedConfigSets;
            synchronized (map) {
                set = this.publishedConfigSets.get(name);
                if (set == null) {
                    set = new PublishedConfigSet();
                    this.publishedConfigSets.put(name, set);
                }
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listConfigSets() {
        Map<String, PublishedConfigSet> map = this.publishedConfigSets;
        synchronized (map) {
            ArrayList<String> sets = new ArrayList<String>(this.publishedConfigSets.keySet());
            return sets;
        }
    }

    @Override
    public Map<Integer, RoleStatus> getRoleStatusMap() {
        return this.appState.getRoleStatusMap();
    }

    @Override
    public Map<ContainerId, RoleInstance> getFailedContainers() {
        return this.appState.getFailedContainers();
    }

    @Override
    public Map<ContainerId, RoleInstance> getLiveContainers() {
        return this.appState.getLiveContainers();
    }

    @Override
    public ClusterDescription getClusterStatus() {
        return this.appState.getClusterStatus();
    }

    @Override
    public ConfTreeOperations getResourcesSnapshot() {
        return this.appState.getResourcesSnapshot();
    }

    @Override
    public ConfTreeOperations getAppConfSnapshot() {
        return this.appState.getAppConfSnapshot();
    }

    @Override
    public ConfTreeOperations getInternalsSnapshot() {
        return this.appState.getInternalsSnapshot();
    }

    @Override
    public boolean isApplicationLive() {
        return this.appState.isApplicationLive();
    }

    @Override
    public long getSnapshotTime() {
        return this.appState.getSnapshotTime();
    }

    @Override
    public AggregateConf getInstanceDefinitionSnapshot() {
        return this.appState.getInstanceDefinitionSnapshot();
    }

    @Override
    public AggregateConf getUnresolvedInstanceDefinition() {
        return this.appState.getUnresolvedInstanceDefinition();
    }

    @Override
    public RoleStatus lookupRoleStatus(int key) {
        return this.appState.lookupRoleStatus(key);
    }

    @Override
    public RoleStatus lookupRoleStatus(Container c) throws YarnRuntimeException {
        return this.appState.lookupRoleStatus(c);
    }

    @Override
    public RoleStatus lookupRoleStatus(String name) throws YarnRuntimeException {
        return this.appState.lookupRoleStatus(name);
    }

    @Override
    public List<RoleInstance> cloneOwnedContainerList() {
        return this.appState.cloneOwnedContainerList();
    }

    @Override
    public int getNumOwnedContainers() {
        return this.appState.getNumOwnedContainers();
    }

    @Override
    public RoleInstance getOwnedContainer(ContainerId id) {
        return this.appState.getOwnedContainer(id);
    }

    @Override
    public RoleInstance getOwnedContainer(String id) throws NoSuchNodeException {
        return this.appState.getOwnedInstanceByContainerID(id);
    }

    @Override
    public List<RoleInstance> cloneLiveContainerInfoList() {
        return this.appState.cloneLiveContainerInfoList();
    }

    @Override
    public RoleInstance getLiveInstanceByContainerID(String containerId) throws NoSuchNodeException {
        return this.appState.getLiveInstanceByContainerID(containerId);
    }

    @Override
    public List<RoleInstance> getLiveInstancesByContainerIDs(Collection<String> containerIDs) {
        return this.appState.getLiveInstancesByContainerIDs(containerIDs);
    }

    @Override
    public ClusterDescription refreshClusterStatus() {
        return this.appState.refreshClusterStatus();
    }

    @Override
    public List<RoleStatus> cloneRoleStatusList() {
        return this.appState.cloneRoleStatusList();
    }

    @Override
    public ApplicationLivenessInformation getApplicationLivenessInformation() {
        return this.appState.getApplicationLivenessInformation();
    }

    @Override
    public Map<String, Integer> getLiveStatistics() {
        return this.appState.getLiveStatistics();
    }

    @Override
    public Map<String, ComponentInformation> getComponentInfoSnapshot() {
        return this.appState.getComponentInfoSnapshot();
    }

    @Override
    public Map<String, Map<String, ClusterNode>> getRoleClusterNodeMapping() {
        return this.appState.createRoleToClusterNodeMap();
    }

    @Override
    public List<RoleInstance> enumLiveInstancesInRole(String role) {
        ArrayList<RoleInstance> nodes = new ArrayList<RoleInstance>();
        List<RoleInstance> allRoleInstances = this.cloneLiveContainerInfoList();
        this.getLiveContainers().values();
        for (RoleInstance node : allRoleInstances) {
            if (!role.isEmpty() && !role.equals(node.role)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public List<RoleInstance> lookupRoleContainers(String component) {
        RoleStatus roleStatus = this.lookupRoleStatus(component);
        List<RoleInstance> ownedContainerList = this.cloneOwnedContainerList();
        ArrayList<RoleInstance> matching = new ArrayList<RoleInstance>(ownedContainerList.size());
        int roleId = roleStatus.getPriority();
        for (RoleInstance instance : ownedContainerList) {
            if (instance.roleId != roleId) continue;
            matching.add(instance);
        }
        return matching;
    }

    @Override
    public ComponentInformation getComponentInformation(String component) {
        RoleStatus roleStatus = this.lookupRoleStatus(component);
        ComponentInformation info = roleStatus.serialize();
        List<RoleInstance> containers = this.lookupRoleContainers(component);
        info.containers = new ArrayList<String>(containers.size());
        for (RoleInstance container : containers) {
            info.containers.add(container.id);
        }
        return info;
    }

    @Override
    public Map<String, NodeInformation> getNodeInformationSnapshot() {
        return this.appState.getRoleHistory().getNodeInformationSnapshot(this.appState.buildNamingMap());
    }

    @Override
    public NodeInformation getNodeInformation(String hostname) {
        return this.appState.getRoleHistory().getNodeInformation(hostname, this.appState.buildNamingMap());
    }

    @Override
    public RoleStatistics getRoleStatistics() {
        return this.appState.getRoleStatistics();
    }
}

