/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.state;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.slider.server.appmaster.state.NodeInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeMap
extends HashMap<String, NodeInstance> {
    protected static final Logger log = LoggerFactory.getLogger(NodeMap.class);
    private final int roleSize;

    public NodeMap(int roleSize) {
        this.roleSize = roleSize;
    }

    public NodeInstance getOrCreate(String hostname) {
        NodeInstance node = (NodeInstance)this.get(hostname);
        if (node == null) {
            node = new NodeInstance(hostname, this.roleSize);
            this.put(hostname, node);
        }
        return node;
    }

    public List<NodeInstance> listActiveNodes(int role) {
        ArrayList<NodeInstance> nodes = new ArrayList<NodeInstance>();
        for (NodeInstance instance : this.values()) {
            if (instance.getActiveRoleInstances(role) <= 0) continue;
            nodes.add(instance);
        }
        Collections.sort(nodes, new NodeInstance.MoreActiveThan(role));
        return nodes;
    }

    public void resetFailedRecently() {
        for (Map.Entry entry : this.entrySet()) {
            NodeInstance ni = (NodeInstance)entry.getValue();
            ni.resetFailedRecently();
        }
    }

    public boolean updateNode(String hostname, NodeReport report) {
        boolean nodeExisted = this.get(hostname) != null;
        boolean updated = this.getOrCreate(hostname).updateNode(report);
        return updated || !nodeExisted;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @VisibleForTesting
    public void insert(Collection<NodeInstance> nodes) {
        for (NodeInstance node : nodes) {
            this.put(node.hostname, node);
        }
    }

    @VisibleForTesting
    public boolean buildOrUpdate(List<NodeReport> reports) {
        boolean updated = false;
        for (NodeReport report : reports) {
            updated |= this.getOrCreate(report.getNodeId().getHost()).updateNode(report);
        }
        return updated;
    }

    public List<NodeInstance> findAllNodesForRole(int role, String label) {
        ArrayList<NodeInstance> nodes = new ArrayList<NodeInstance>(this.size());
        for (NodeInstance instance : this.values()) {
            if (!instance.canHost(role, label)) continue;
            nodes.add(instance);
        }
        Collections.sort(nodes, new NodeInstance.CompareNames());
        return nodes;
    }

    @Override
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("NodeMap{");
        ArrayList keys = new ArrayList(this.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            sb.append(key).append(": ");
            sb.append(((NodeInstance)this.get(key)).toFullString()).append("\n");
        }
        sb.append('}');
        return sb.toString();
    }
}

