/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.common.params;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import org.apache.slider.common.params.AbstractActionArgs;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.UsageException;
import org.apache.slider.core.registry.docstore.ConfigFormat;

@Parameters(commandNames={"registry"}, commandDescription="Query the registry of a YARN application")
public class ActionRegistryArgs
extends AbstractActionArgs {
    public static final String USAGE = "Usage: registry (--list|--listconf|--listexp|--listfiles|--getconf|--getexp> --name <name>  )[--verbose] [--user] [--out <filename> ] [--servicetype <servicetype> ] [--format <xml|json|properties>] " + System.getProperty("line.separator") + "Arguments.ARG_GETEXP only supports " + "--format" + " json";
    @Parameter(names={"--list"}, description="list services")
    public boolean list;
    @Parameter(names={"--listconf"}, description="list configurations")
    public boolean listConf;
    @Parameter(names={"--getconf"}, description="get configuration")
    public String getConf;
    @Parameter(names={"--listexp"}, description="list exports")
    public boolean listExports;
    @Parameter(names={"--getexp"}, description="get export")
    public String getExport;
    @Parameter(names={"--listfiles"}, description="list files")
    public String listFiles;
    @Parameter(names={"--getfiles"}, description="get files")
    public String getFiles;
    @Parameter(names={"--format"}, description="Format for a response: <xml|json|properties>")
    public String format = ConfigFormat.XML.toString();
    @Parameter(names={"--out", "-o", "--dest"}, description="Output destination")
    public File out;
    @Parameter(names={"--name"}, description="name of an instance")
    public String name;
    @Parameter(names={"--servicetype"}, description="optional service type")
    public String serviceType = "org-apache-slider";
    @Parameter(names={"--verbose"}, description="verbose output")
    public boolean verbose;
    @Parameter(names={"--internal"}, description="fetch internal registry entries")
    public boolean internal;
    @Parameter(names={"--user"}, description="the name of the user whose application is being resolved")
    public String user;

    public ActionRegistryArgs() {
    }

    public ActionRegistryArgs(String name) {
        this.name = name;
    }

    @Override
    public String getActionName() {
        return "registry";
    }

    @Override
    public int getMinParams() {
        return 0;
    }

    @Override
    public void validate() throws BadCommandArgumentsException, UsageException {
        super.validate();
        int gets = this.s(this.getConf) + this.s(this.getFiles) + this.s(this.getExport);
        int lists = this.s(this.list) + this.s(this.listConf) + this.s(this.listFiles) + this.s(this.listExports);
        int set = lists + gets;
        if (set > 1) {
            throw new UsageException(USAGE, new Object[0]);
        }
        if (this.out != null && set == 0) {
            throw new UsageException("output path is only supported on 'get' operations: ", new Object[0]);
        }
        if (!this.list && !this.is(this.name)) {
            throw new UsageException("Argument --name missing: ", new Object[0]);
        }
    }

    private int s(String arg) {
        return this.is(arg) ? 1 : 0;
    }

    private boolean is(String arg) {
        return arg != null;
    }

    private int s(boolean arg) {
        return arg ? 1 : 0;
    }

    private String ifdef(String arg, boolean val) {
        return val ? String.valueOf(arg) + " " : "";
    }

    private String ifdef(String arg, String val) {
        if (this.is(val)) {
            return String.valueOf(arg) + " " + val + " ";
        }
        return "";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("registry");
        sb.append(' ');
        sb.append(this.ifdef("--list", this.list));
        sb.append(this.ifdef("--listconf", this.listConf));
        sb.append(this.ifdef("--listfiles", this.listFiles));
        sb.append(this.ifdef("--getconf", this.getConf));
        sb.append(this.ifdef("--getfiles", this.getFiles));
        sb.append(this.ifdef("--name", this.name));
        sb.append(this.ifdef("--servicetype", this.serviceType));
        sb.append(this.ifdef("--verbose", this.verbose));
        sb.append(this.ifdef("--internal", this.internal));
        if (this.out != null) {
            sb.append(this.ifdef("--out", this.out.toString()));
        }
        sb.append(this.ifdef("--format", this.format));
        return sb.toString();
    }
}

