/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.client.rest;

import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import java.io.IOException;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.apache.slider.api.SliderApplicationApi;
import org.apache.slider.api.types.ApplicationLivenessInformation;
import org.apache.slider.api.types.ComponentInformation;
import org.apache.slider.api.types.ContainerInformation;
import org.apache.slider.api.types.NodeInformation;
import org.apache.slider.api.types.NodeInformationList;
import org.apache.slider.api.types.PingInformation;
import org.apache.slider.client.rest.BaseRestClient;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.exceptions.ExceptionConverter;
import org.apache.slider.core.restclient.HttpVerb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliderApplicationApiRestClient
extends BaseRestClient
implements SliderApplicationApi {
    private static final Logger log = LoggerFactory.getLogger(SliderApplicationApiRestClient.class);
    private WebResource appResource;

    public SliderApplicationApiRestClient(Client jerseyClient, WebResource appResource) {
        super(jerseyClient);
        this.appResource = appResource;
    }

    public SliderApplicationApiRestClient(Client jerseyClient, String appmaster) {
        super(jerseyClient);
        WebResource amResource = jerseyClient.resource(appmaster);
        amResource.type("application/json");
        this.appResource = amResource.path("/ws/v1/slider/application");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SliderApplicationApiRestClient{");
        sb.append("appResource=").append(this.appResource);
        sb.append('}');
        return sb.toString();
    }

    public WebResource applicationResource(String subpath) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)subpath) ? 1 : 0) != 0, (Object)"empty path");
        Preconditions.checkNotNull((Object)this.appResource, (Object)"Null app resource");
        return this.appResource.path(subpath);
    }

    public <T> T getApplicationResource(String subpath, Class<T> c) throws IOException {
        return this.appResourceOperation(HttpVerb.GET, subpath, c);
    }

    public <T> T getApplicationResource(String subpath, GenericType<T> t) throws IOException {
        return this.appResourceOperation(HttpVerb.GET, subpath, t);
    }

    public <T> T appResourceOperation(HttpVerb method, String subpath, Class<T> c) throws IOException {
        return this.exec(method, this.applicationResource(subpath), c);
    }

    public <T> T appResourceOperation(HttpVerb method, String subpath, GenericType<T> t) throws IOException {
        return this.exec(method, this.applicationResource(subpath), t);
    }

    @Override
    public AggregateConf getDesiredModel() throws IOException {
        return this.getApplicationResource("/model/desired", AggregateConf.class);
    }

    @Override
    public ConfTreeOperations getDesiredAppconf() throws IOException {
        ConfTree resource = this.getApplicationResource("/model/desired/appconf", ConfTree.class);
        return new ConfTreeOperations(resource);
    }

    @Override
    public ConfTreeOperations getDesiredResources() throws IOException {
        ConfTree resource = this.getApplicationResource("/model/desired/resources", ConfTree.class);
        return new ConfTreeOperations(resource);
    }

    @Override
    public void putDesiredResources(ConfTree updated) throws IOException {
        WebResource resource = this.applicationResource("/model/desired/resources");
        try {
            ((WebResource.Builder)((WebResource.Builder)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).entity((Object)updated)).put(ConfTree.class);
        }
        catch (ClientHandlerException ex) {
            throw ExceptionConverter.convertJerseyException("PUT", resource.getURI().toString(), ex);
        }
        catch (UniformInterfaceException ex) {
            throw ExceptionConverter.convertJerseyException("PUT", resource.getURI().toString(), ex);
        }
    }

    @Override
    public AggregateConf getResolvedModel() throws IOException {
        return this.getApplicationResource("/model/resolved", AggregateConf.class);
    }

    @Override
    public ConfTreeOperations getResolvedAppconf() throws IOException {
        ConfTree resource = this.getApplicationResource("/model/resolved/appconf", ConfTree.class);
        return new ConfTreeOperations(resource);
    }

    @Override
    public ConfTreeOperations getResolvedResources() throws IOException {
        ConfTree resource = this.getApplicationResource("/model/resolved/resources", ConfTree.class);
        return new ConfTreeOperations(resource);
    }

    @Override
    public ConfTreeOperations getLiveResources() throws IOException {
        ConfTree resource = this.getApplicationResource("/live/resources", ConfTree.class);
        return new ConfTreeOperations(resource);
    }

    @Override
    public Map<String, ContainerInformation> enumContainers() throws IOException {
        return this.getApplicationResource("/live/containers", new GenericType<Map<String, ContainerInformation>>(){});
    }

    @Override
    public ContainerInformation getContainer(String containerId) throws IOException {
        return this.getApplicationResource("/live/containers/" + containerId, ContainerInformation.class);
    }

    @Override
    public Map<String, ComponentInformation> enumComponents() throws IOException {
        return this.getApplicationResource("/live/components", new GenericType<Map<String, ComponentInformation>>(){});
    }

    @Override
    public ComponentInformation getComponent(String componentName) throws IOException {
        return this.getApplicationResource("/live/components/" + componentName, ComponentInformation.class);
    }

    @Override
    public NodeInformationList getLiveNodes() throws IOException {
        return this.getApplicationResource("/live/nodes", NodeInformationList.class);
    }

    @Override
    public NodeInformation getLiveNode(String hostname) throws IOException {
        return this.getApplicationResource("/live/nodes/" + hostname, NodeInformation.class);
    }

    @Override
    public PingInformation ping(String text) throws IOException {
        return this.pingPost(text);
    }

    public PingInformation pingGet(String text) throws IOException {
        WebResource pingResource = this.applicationResource("/action/ping");
        pingResource.getUriBuilder().queryParam("body", new Object[]{text});
        return (PingInformation)pingResource.get(PingInformation.class);
    }

    public PingInformation pingPost(String text) throws IOException {
        WebResource pingResource = this.applicationResource("/action/ping");
        Form f = new Form();
        f.add("text", text);
        return (PingInformation)pingResource.type(MediaType.APPLICATION_JSON_TYPE).post(PingInformation.class, (Object)f);
    }

    public PingInformation pingPut(String text) throws IOException {
        WebResource pingResource = this.applicationResource("/action/ping");
        new Form();
        return (PingInformation)pingResource.type("text/plain").put(PingInformation.class, (Object)text);
    }

    @Override
    public void stop(String text) throws IOException {
        WebResource resource = this.applicationResource("/action/stop");
        resource.post((Object)text);
    }

    @Override
    public ApplicationLivenessInformation getApplicationLiveness() throws IOException {
        return this.getApplicationResource("/live/liveness", ApplicationLivenessInformation.class);
    }
}

